/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.managed;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.jboss.as.arquillian.container.CommonManagedDeployableContainer;
import org.jboss.as.arquillian.container.ParameterUtils;
import org.jboss.as.arquillian.container.managed.ManagedContainerConfiguration;
import org.jboss.logging.Logger;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.StandaloneCommandBuilder;

public final class ManagedDeployableContainer
extends CommonManagedDeployableContainer<ManagedContainerConfiguration> {
    private static final Pattern WHITESPACE_OR_COMMA_DELIMITED = Pattern.compile("(\\s+|,)(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)");
    static final String TEMP_CONTAINER_DIRECTORY = "arquillian-temp-container";
    static final String CONFIG_DIR = "configuration";
    static final String DATA_DIR = "data";
    private final Logger log = Logger.getLogger(ManagedDeployableContainer.class);

    public Class<ManagedContainerConfiguration> getConfigurationClass() {
        return ManagedContainerConfiguration.class;
    }

    protected CommandBuilder createCommandBuilder(ManagedContainerConfiguration config) {
        String moduleOptions;
        String bundlesPath;
        StandaloneCommandBuilder commandBuilder = StandaloneCommandBuilder.of((String)config.getJbossHome());
        String modulesPath = config.getModulePath();
        if (modulesPath != null && !modulesPath.isEmpty()) {
            commandBuilder.setModuleDirs(modulesPath.split(Pattern.quote(File.pathSeparator)));
        }
        if ((bundlesPath = config.getBundlePath()) != null && !bundlesPath.isEmpty()) {
            this.log.warn((Object)"Bundles path is deprecated and no longer used.");
        }
        String javaOpts = config.getJavaVmArguments();
        String jbossArguments = config.getJbossArguments();
        commandBuilder.setJavaHome(config.getJavaHome());
        if (javaOpts != null && !javaOpts.trim().isEmpty()) {
            commandBuilder.setJavaOptions((Iterable)ParameterUtils.splitParams((String)javaOpts));
        }
        if ((moduleOptions = config.getModuleOptions()) != null && !moduleOptions.isBlank()) {
            commandBuilder.setModuleOptions((Iterable)ParameterUtils.splitParams((String)moduleOptions));
        }
        if (config.isEnableAssertions()) {
            commandBuilder.addJavaOption("-ea");
        }
        if (config.isAdminOnly()) {
            commandBuilder.setAdminOnly();
        }
        if (jbossArguments != null && !jbossArguments.trim().isEmpty()) {
            commandBuilder.addServerArguments((Iterable)ParameterUtils.splitParams((String)jbossArguments));
        }
        if (config.getServerConfig() != null) {
            commandBuilder.setServerConfiguration(config.getServerConfig());
        } else if (config.getReadOnlyServerConfig() != null) {
            commandBuilder.setServerReadOnlyConfiguration(config.getReadOnlyServerConfig());
        }
        if (config.getYamlConfiguration() != null) {
            commandBuilder.setYamlFiles(this.findSupplementalConfigurationFiles(commandBuilder.getConfigurationDirectory(), config.getYamlConfiguration()));
        }
        if (config.isSetupCleanServerBaseDir() || config.getCleanServerBaseDir() != null) {
            try {
                ManagedDeployableContainer.setupCleanServerDirectories(commandBuilder, config.getCleanServerBaseDir());
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to setup the clean server directory.", e);
            }
        }
        commandBuilder.addJavaOption("-Djboss.home.dir=" + commandBuilder.getWildFlyHome());
        return commandBuilder;
    }

    private Path[] findSupplementalConfigurationFiles(Path serverConfigurationDirPath, String yaml) {
        ArrayList<Path> yamlFiles = new ArrayList<Path>();
        for (String yamlFile : WHITESPACE_OR_COMMA_DELIMITED.split(yaml)) {
            Path path = Path.of(yamlFile, new String[0]);
            if (path.isAbsolute()) {
                yamlFiles.add(path);
                continue;
            }
            yamlFiles.add(serverConfigurationDirPath.resolve(path));
        }
        ArrayList<Path> invalidPaths = new ArrayList<Path>();
        for (Path yamlFile : yamlFiles) {
            if (!Files.notExists(yamlFile, new LinkOption[0])) continue;
            invalidPaths.add(yamlFile);
        }
        if (!invalidPaths.isEmpty()) {
            throw new IllegalStateException(String.format("Invalid YAML paths found in %s: %s", yaml, invalidPaths));
        }
        return yamlFiles.toArray(new Path[0]);
    }

    protected Logger getLogger() {
        return this.log;
    }

    private static void setupCleanServerDirectories(StandaloneCommandBuilder commandBuilder, String cleanServerBaseDirPath) throws IOException {
        Path cleanBase = cleanServerBaseDirPath != null ? Paths.get(cleanServerBaseDirPath, new String[0]) : Files.createTempDirectory(TEMP_CONTAINER_DIRECTORY, new FileAttribute[0]);
        if (Files.notExists(cleanBase, new LinkOption[0])) {
            throw new IllegalStateException(String.format("Base directory %s does not exist.", cleanBase));
        }
        if (!Files.isDirectory(cleanBase, new LinkOption[0])) {
            throw new IllegalStateException(String.format("Base directory %s is not a directory.", cleanBase));
        }
        Path currentConfigDir = commandBuilder.getConfigurationDirectory();
        Path configDir = cleanBase.resolve(CONFIG_DIR);
        ManagedDeployableContainer.copyDir(currentConfigDir, configDir);
        Path currentDataDir = commandBuilder.getBaseDirectory().resolve(DATA_DIR);
        if (Files.exists(currentDataDir, new LinkOption[0])) {
            ManagedDeployableContainer.copyDir(currentDataDir, cleanBase.resolve(DATA_DIR));
        }
        commandBuilder.setBaseDirectory(cleanBase);
        commandBuilder.setConfigurationDirectory(configDir);
    }

    private static void copyDir(final Path from, final Path to) throws IOException {
        Files.walkFileTree(from, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Files.copy(dir, to.resolve(from.relativize(dir)), new CopyOption[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.copy(file, to.resolve(from.relativize(file)), new CopyOption[0]);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

