/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.action.mappings;

import org.aesh.readline.ConsoleBuffer;
import org.aesh.readline.InputProcessor;
import org.aesh.readline.action.Action;
import org.aesh.readline.util.Parser;
import org.aesh.terminal.utils.Config;

public class Enter
implements Action {
    private static final String ENDS_WITH_BACKSLASH = "\\";
    private static final String HASHTAG = "#";

    @Override
    public String name() {
        return "accept-line";
    }

    @Override
    public void accept(InputProcessor inputProcessor) {
        ConsoleBuffer consoleBuffer = inputProcessor.buffer();
        consoleBuffer.undoManager().clear();
        boolean isCurrentLineEnding = true;
        if (!consoleBuffer.buffer().isMasking()) {
            String buffer = consoleBuffer.buffer().asString().trim();
            if (buffer.startsWith(HASHTAG)) {
                consoleBuffer.buffer().reset();
                inputProcessor.buffer().writeOut(Config.CR);
                isCurrentLineEnding = false;
            } else if (buffer.endsWith(ENDS_WITH_BACKSLASH)) {
                consoleBuffer.buffer().setMultiLine(true);
                consoleBuffer.buffer().updateMultiLineBuffer();
                inputProcessor.buffer().writeOut(Config.CR);
                isCurrentLineEnding = false;
            } else if (Parser.doesStringContainOpenQuote(buffer)) {
                consoleBuffer.buffer().setMultiLine(true);
                consoleBuffer.buffer().updateMultiLineBuffer();
                inputProcessor.buffer().writeOut(Config.CR);
                isCurrentLineEnding = false;
            } else if (inputProcessor.buffer().history().isEnabled()) {
                inputProcessor.buffer().history().push(consoleBuffer.buffer().multiLine());
            }
        }
        if (isCurrentLineEnding) {
            consoleBuffer.moveCursor(consoleBuffer.buffer().length());
        }
        if (isCurrentLineEnding) {
            inputProcessor.setReturnValue(consoleBuffer.buffer().multiLine());
            consoleBuffer.buffer().reset();
        } else {
            consoleBuffer.drawLine();
        }
    }
}

