/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.security.model;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.aesh.command.CommandException;
import org.aesh.readline.Prompt;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.impl.aesh.cmd.security.SecurityCommand;
import org.jboss.as.cli.impl.aesh.cmd.security.model.DefaultResourceNames;
import org.jboss.as.cli.impl.aesh.cmd.security.model.ElytronUtil;
import org.jboss.as.cli.impl.aesh.cmd.security.model.KeyStore;
import org.jboss.as.cli.impl.aesh.cmd.security.model.SSLSecurityBuilder;
import org.jboss.as.cli.impl.aesh.cmd.security.ssl.PromptFileCompleter;
import org.jboss.dmr.ModelNode;
import org.wildfly.core.cli.command.aesh.CLICommandInvocation;
import org.wildfly.security.x500.cert.acme.CertificateAuthority;

public class InteractiveSecurityBuilder
extends SSLSecurityBuilder {
    private String dn;
    private String password;
    private String alias;
    private CLICommandInvocation commandInvocation;
    private String validity;
    private String keyStoreName;
    private String clientCertificate;
    private String trustStoreFileName;
    private String trustStorePassword;
    private boolean validateCertificate;
    public static final String PLACE_HOLDER = "<need user input>";
    private String keyStoreFile;
    private final String defaultKeyStoreFile;
    private final String defaultTrustStoreFile;
    private final boolean useLetsEncrypt;
    private final String caAccount;
    private String accountKeyStoreName;
    private String accountKeyStoreFile;
    private String accountKeyStorePassword;
    private CertificateAuthority certificateAuthority;
    private String certAuthorityAccountName;
    private List<String> contactUrls;
    private String certAuthorityAccountPassword;
    private String certAuthorityAccountAlias;
    private boolean agreedToTOS = false;
    private List<String> domainNames;
    private static final String defaultAccountKeyStoreFile = "accounts.keystore.jks";
    private static final String defaultCertAuthorityAccountName = "CertAuthorityAccount";
    private static final String KEY_ALG = "RSA";
    private static final int KEY_SIZE = 2048;

    public InteractiveSecurityBuilder(String defaultKeyStoreFile, String defaultTrustStoreFile, boolean useLetsEncrypt, String caAccount) throws CommandException {
        this.defaultKeyStoreFile = defaultKeyStoreFile;
        this.defaultTrustStoreFile = defaultTrustStoreFile;
        this.useLetsEncrypt = useLetsEncrypt;
        this.caAccount = caAccount;
    }

    public InteractiveSecurityBuilder setCommandInvocation(CLICommandInvocation commandInvocation) {
        this.commandInvocation = commandInvocation;
        return this;
    }

    @Override
    public void buildRequest(CommandContext ctx, boolean buildRequest) throws Exception {
        if (buildRequest) {
            this.keyStoreFile = PLACE_HOLDER;
            this.dn = PLACE_HOLDER;
            this.password = PLACE_HOLDER;
            this.alias = PLACE_HOLDER;
            this.validity = PLACE_HOLDER;
            this.clientCertificate = File.separator + PLACE_HOLDER;
            this.trustStorePassword = PLACE_HOLDER;
            this.trustStoreFileName = PLACE_HOLDER;
            this.accountKeyStoreFile = PLACE_HOLDER;
            this.accountKeyStorePassword = PLACE_HOLDER;
            this.certAuthorityAccountName = PLACE_HOLDER;
            this.contactUrls = new ArrayList<String>();
            this.contactUrls.add(PLACE_HOLDER);
            this.certAuthorityAccountPassword = PLACE_HOLDER;
            this.certAuthorityAccountAlias = PLACE_HOLDER;
            this.agreedToTOS = true;
            this.domainNames = new ArrayList<String>();
            this.domainNames.add(PLACE_HOLDER);
        } else {
            ctx.printLine("Please provide required pieces of information to enable SSL:");
        }
        String relativeTo = "jboss.server.config.dir";
        String id = UUID.randomUUID().toString();
        boolean ok = false;
        if (this.useLetsEncrypt && this.caAccount != null) {
            this.certAuthorityAccountName = this.caAccount;
        }
        if (this.useLetsEncrypt && this.caAccount == null) {
            ctx.print("\nLet's Encrypt account key-store:");
            while (this.accountKeyStoreFile == null) {
                List<String> ksNames;
                this.accountKeyStoreFile = this.commandInvocation.inputLine(new Prompt("File name (default accounts.keystore.jks): "));
                if (this.accountKeyStoreFile != null && this.accountKeyStoreFile.length() == 0) {
                    this.accountKeyStoreFile = defaultAccountKeyStoreFile;
                }
                if ((ksNames = ElytronUtil.findMatchingKeyStores(ctx, new File(this.accountKeyStoreFile), relativeTo)).isEmpty()) continue;
                throw new CommandException("Error, the file " + this.accountKeyStoreFile + " is already referenced from " + ksNames + " resources. Use " + SecurityCommand.formatOption("key-store-name") + " option or choose another file name.");
            }
            while (this.accountKeyStorePassword == null) {
                this.accountKeyStorePassword = this.commandInvocation.inputLine(new Prompt("Password (blank generated): "));
                if (this.accountKeyStorePassword == null || this.accountKeyStorePassword.length() != 0) continue;
                this.accountKeyStorePassword = SSLSecurityBuilder.generateRandomPassword();
            }
            ctx.print("\nLet's Encrypt certificate authority account:");
            while (this.certAuthorityAccountName == null) {
                List<String> caAccountNames;
                this.certAuthorityAccountName = this.commandInvocation.inputLine(new Prompt("Account name (default CertAuthorityAccount): "));
                if (this.certAuthorityAccountName != null && this.certAuthorityAccountName.length() == 0) {
                    this.certAuthorityAccountName = defaultCertAuthorityAccountName;
                }
                if (!(caAccountNames = ElytronUtil.getCaAccountNames(ctx.getModelControllerClient())).contains(this.certAuthorityAccountName)) continue;
                throw new CommandException("Error, the certificate authority account " + this.certAuthorityAccountName + " already exists.");
            }
            while (this.contactUrls == null) {
                String emails = this.commandInvocation.inputLine(new Prompt("Contact email(s) [admin@example.com,info@example.com]: "));
                this.contactUrls = this.parseEmails(emails);
            }
            while (this.certAuthorityAccountPassword == null) {
                this.certAuthorityAccountPassword = this.commandInvocation.inputLine(new Prompt("Password (blank generated): "));
                if (this.certAuthorityAccountPassword == null || this.certAuthorityAccountPassword.length() != 0) continue;
                this.certAuthorityAccountPassword = SSLSecurityBuilder.generateRandomPassword();
            }
            while (this.certAuthorityAccountAlias == null) {
                this.certAuthorityAccountAlias = this.commandInvocation.inputLine(new Prompt("Alias (blank generated): "));
                if (this.certAuthorityAccountAlias == null || this.certAuthorityAccountAlias.length() != 0) continue;
                this.certAuthorityAccountAlias = "account-key-store-alias-" + id;
            }
            this.certificateAuthority = CertificateAuthority.getDefault();
            String certificateAuthorityUrl = null;
            while (certificateAuthorityUrl == null) {
                certificateAuthorityUrl = this.commandInvocation.inputLine(new Prompt("Certificate authority URL (default " + this.certificateAuthority.getUrl() + "): "));
                if (certificateAuthorityUrl == null || certificateAuthorityUrl.isEmpty()) continue;
                URI certAuthUri = new URI(certificateAuthorityUrl);
                this.certificateAuthority = new CertificateAuthority(certAuthUri.getHost(), certificateAuthorityUrl, certificateAuthorityUrl);
            }
            if (!buildRequest) {
                String reply = null;
                while (reply == null) {
                    ctx.print("\nLet's Encrypt TOS (https://community.letsencrypt.org/tos)");
                    reply = this.commandInvocation.inputLine(new Prompt("Do you agree to Let's Encrypt terms of service? y/n:"));
                    if (reply != null && reply.equals("y")) {
                        this.agreedToTOS = true;
                        break;
                    }
                    if (reply == null || reply.equals("n")) continue;
                    reply = null;
                }
                if (!this.agreedToTOS) {
                    throw new CommandException("Ignoring, command not executed. You need to accept the TOS to create account and obtain certificates.");
                }
            }
        }
        Long v = null;
        ctx.print("\nCertificate info:");
        while (this.keyStoreFile == null) {
            List<String> ksNames;
            this.keyStoreFile = this.commandInvocation.inputLine(new Prompt("Key-store file name (default " + this.defaultKeyStoreFile + "): "));
            if (this.keyStoreFile != null && this.keyStoreFile.length() == 0) {
                this.keyStoreFile = this.defaultKeyStoreFile;
            }
            if ((ksNames = ElytronUtil.findMatchingKeyStores(ctx, new File(this.keyStoreFile), relativeTo)).isEmpty()) continue;
            throw new CommandException("Error, the file " + this.keyStoreFile + " is already referenced from " + ksNames + " resources. Use " + SecurityCommand.formatOption("key-store-name") + " option or choose another file name.");
        }
        int i = this.keyStoreFile.indexOf(".");
        String certName = i > 0 ? this.keyStoreFile.substring(0, i) : this.keyStoreFile;
        String csrName = certName + ".csr";
        certName = certName + ".pem";
        while (this.password == null) {
            this.password = this.commandInvocation.inputLine(new Prompt("Password (blank generated): "));
            if (this.password == null || this.password.length() != 0) continue;
            this.password = SSLSecurityBuilder.generateRandomPassword();
        }
        if (this.useLetsEncrypt) {
            while (this.domainNames == null || this.domainNames.size() < 1) {
                String domains = this.commandInvocation.inputLine(new Prompt("Your domain name(s) (must be accessible by the Let's Encrypt server at 80 & 443 ports) [example.com,second.example.com]: "));
                this.domainNames = this.parseItemsFromString(domains);
            }
            this.validity = "90";
        } else {
            if (this.dn == null) {
                this.dn = new DNWizard().buildDN();
            }
            while (this.validity == null) {
                this.validity = this.commandInvocation.inputLine(new Prompt("Validity (in days, blank default): "));
                if (this.validity == null) continue;
                if (this.validity.length() == 0) {
                    v = null;
                    continue;
                }
                try {
                    v = Long.parseLong(this.validity);
                }
                catch (NumberFormatException e) {
                    ctx.printLine("Invalid number " + this.validity);
                    this.validity = null;
                }
            }
        }
        while (this.alias == null) {
            this.alias = this.commandInvocation.inputLine(new Prompt("Alias (blank generated): "));
            if (this.alias == null || this.alias.length() != 0) continue;
            this.alias = "alias-" + id;
        }
        boolean mutual = false;
        if (!buildRequest) {
            String twoWay = null;
            while (twoWay == null) {
                twoWay = this.commandInvocation.inputLine(new Prompt("Enable SSL Mutual Authentication y/n (blank n):"));
                if (twoWay != null && twoWay.equals("y")) {
                    mutual = true;
                    break;
                }
                if (twoWay != null && twoWay.equals("n")) {
                    mutual = false;
                    break;
                }
                if (twoWay != null && twoWay.length() == 0) {
                    mutual = false;
                    break;
                }
                twoWay = null;
            }
            if (mutual) {
                PromptFileCompleter completer = new PromptFileCompleter(this.commandInvocation.getConfiguration().getAeshContext());
                while (this.clientCertificate == null || this.clientCertificate.length() == 0) {
                    this.clientCertificate = this.commandInvocation.inputLine(new Prompt("Client certificate (path to pem file): "), completer);
                    if (this.clientCertificate == null || this.clientCertificate.length() <= 0 || new File(this.clientCertificate).exists()) continue;
                    this.clientCertificate = null;
                    ctx.printLine("The specified file doesn't exist");
                }
                String val = null;
                while (val == null) {
                    val = this.commandInvocation.inputLine(new Prompt("Validate certificate y/n (blank y): "));
                    if (val != null && val.equals("y")) {
                        this.validateCertificate = true;
                        break;
                    }
                    if (val != null && val.equals("n")) {
                        this.validateCertificate = false;
                        break;
                    }
                    if (val != null && val.length() == 0) {
                        this.validateCertificate = true;
                        break;
                    }
                    val = null;
                }
                while (this.trustStoreFileName == null) {
                    List<String> ksNames;
                    this.trustStoreFileName = this.commandInvocation.inputLine(new Prompt("Trust-store file name (" + this.defaultTrustStoreFile + "): "));
                    if (this.trustStoreFileName != null && this.trustStoreFileName.length() == 0) {
                        this.trustStoreFileName = this.defaultTrustStoreFile;
                    }
                    if ((ksNames = ElytronUtil.findMatchingKeyStores(ctx, new File(this.trustStoreFileName), "jboss.server.config.dir")).isEmpty()) continue;
                    throw new CommandException("Error, the file " + this.trustStoreFileName + " is already referenced from " + ksNames + " resources. Use " + SecurityCommand.formatOption("trust-store-name") + " option or choose another file name.");
                }
                while (this.trustStorePassword == null) {
                    this.trustStorePassword = this.commandInvocation.inputLine(new Prompt("Password (blank generated): "));
                    if (this.trustStorePassword == null || this.trustStorePassword.length() != 0) continue;
                    this.trustStorePassword = SSLSecurityBuilder.generateRandomPassword();
                }
            }
        }
        this.keyStoreName = "key-store-" + id;
        this.accountKeyStoreName = "account-key-store-" + id;
        this.setKeyManagerName("key-manager-" + id);
        this.setSSLContextName("ssl-context-" + id);
        if (!buildRequest) {
            String reply = null;
            while (reply == null) {
                if (this.useLetsEncrypt && this.caAccount == null) {
                    ctx.printLine("\nLet's Encrypt options:\naccount key store name: " + this.accountKeyStoreName + "\npassword: " + this.accountKeyStorePassword + "\naccount keystore file " + this.accountKeyStoreFile + " will be generated in server configuration directory.\nLet's Encrypt certificate authority account name: " + this.certAuthorityAccountName + "\ncontact urls: " + this.contactUrls + "\npassword: " + this.certAuthorityAccountPassword + "\nalias: " + this.certAuthorityAccountAlias + "\ncertificate authority URL: " + this.certificateAuthority.getUrl() + "\nYou provided agreement to Let's Encrypt terms of service.\n");
                } else if (this.caAccount != null) {
                    ctx.printLine("Let's Encrypt certificate authority account name: " + this.certAuthorityAccountName + "\n");
                }
                ctx.printLine("\nSSL options:");
                ctx.printLine("key store file: " + this.keyStoreFile + "\n" + (this.useLetsEncrypt ? "domain name: " + this.domainNames + "\n" : "distinguished name: " + this.dn + "\n") + "password: " + this.password + "\nvalidity: " + (this.validity.length() == 0 ? "default" : this.validity) + "\nalias: " + this.alias);
                if (mutual) {
                    ctx.printLine("client certificate: " + this.clientCertificate);
                    ctx.printLine("trust store file: " + this.trustStoreFileName);
                    ctx.printLine("trust store password: " + this.trustStorePassword);
                }
                if (this.useLetsEncrypt) {
                    ctx.printLine("Certificate will be obtained from Let's Encrypt server and will be valid for 90 days.\nServer keystore file will be generated in server configuration directory.");
                } else {
                    ctx.printLine("Server keystore file " + this.keyStoreFile + ", certificate file " + certName + " and " + csrName + " file will be generated in server configuration directory.");
                }
                if (mutual) {
                    ctx.printLine("Server truststore file " + this.trustStoreFileName + " will be generated in server configuration directory.");
                }
                if ((reply = this.commandInvocation.inputLine(new Prompt("Do you confirm y/n :"))) != null && reply.equals("y")) {
                    ok = true;
                    break;
                }
                if (reply == null || reply.equals("n")) continue;
                reply = null;
            }
            if (!ok) {
                throw new CommandException("Ignoring, command not executed.");
            }
        }
        String type = DefaultResourceNames.buildDefaultKeyStoreType(null, ctx);
        ModelNode request = ElytronUtil.addKeyStore(ctx, this.keyStoreName, new File(this.keyStoreFile), relativeTo, this.password, type, false, null);
        try {
            if (buildRequest) {
                this.addStep(request, this.NO_DESC);
            } else {
                SecurityCommand.execute(ctx, request, SecurityCommand.DEFAULT_FAILURE_CONSUMER);
            }
            if (this.useLetsEncrypt) {
                if (this.caAccount == null) {
                    if (this.certificateAuthority != CertificateAuthority.getDefault()) {
                        final ModelNode requestAddCertAuth = ElytronUtil.addCertificateAuthority(this.certificateAuthority);
                        if (buildRequest) {
                            this.addStep(requestAddCertAuth, this.NO_DESC);
                        } else {
                            SecurityCommand.execute(ctx, requestAddCertAuth, new SecurityCommand.FailureConsumer(){

                                @Override
                                public void failureOccured(CommandContext ctx, ModelNode reply) throws CommandException {
                                    throw new CommandException(Util.getFailureDescription(reply) + " " + requestAddCertAuth.asString());
                                }
                            });
                        }
                    }
                    final ModelNode requestAddAccKS = ElytronUtil.addKeyStore(ctx, this.accountKeyStoreName, new File(this.accountKeyStoreFile), relativeTo, this.accountKeyStorePassword, type, false, null);
                    final ModelNode requestAddCertAuthAcc = ElytronUtil.addCertificateAuthorityAccount(this.certAuthorityAccountName, this.certAuthorityAccountPassword, this.certAuthorityAccountAlias, this.accountKeyStoreName, this.contactUrls, this.certificateAuthority);
                    if (buildRequest) {
                        this.addStep(requestAddAccKS, this.NO_DESC);
                        this.addStep(requestAddCertAuthAcc, this.NO_DESC);
                    } else {
                        SecurityCommand.execute(ctx, requestAddAccKS, new SecurityCommand.FailureConsumer(){

                            @Override
                            public void failureOccured(CommandContext ctx, ModelNode reply) throws CommandException {
                                throw new CommandException(Util.getFailureDescription(reply) + " " + requestAddAccKS.asString());
                            }
                        });
                        SecurityCommand.execute(ctx, requestAddCertAuthAcc, new SecurityCommand.FailureConsumer(){

                            @Override
                            public void failureOccured(CommandContext ctx, ModelNode reply) throws CommandException {
                                throw new CommandException(Util.getFailureDescription(reply) + " " + requestAddCertAuthAcc.asString());
                            }
                        });
                    }
                    this.needKeyStoreStore(this.accountKeyStoreName);
                }
                this.needKeyStoreStore(this.keyStoreName);
                ModelNode request3 = ElytronUtil.obtainCertificateRequest(this.keyStoreName, this.alias, this.password, this.domainNames, this.certAuthorityAccountName, this.agreedToTOS, 2048, KEY_ALG);
                this.addStep(request3, new SSLSecurityBuilder.FailureDescProvider(){

                    @Override
                    public String stepFailedDescription() {
                        return "Obtaining certificate from Let's Encrypt for keystore " + InteractiveSecurityBuilder.this.keyStoreName;
                    }
                });
            } else {
                ModelNode request2 = ElytronUtil.generateKeyPair(ctx, this.keyStoreName, this.dn, this.alias, v, KEY_ALG, 2048);
                this.addStep(request2, new SSLSecurityBuilder.FailureDescProvider(){

                    @Override
                    public String stepFailedDescription() {
                        return "Generating key-pair from " + InteractiveSecurityBuilder.this.keyStoreName;
                    }
                });
                this.needKeyStoreStore(this.keyStoreName);
                final String cName = certName;
                ModelNode request4 = ElytronUtil.exportCertificate(ctx, this.keyStoreName, new File(certName), relativeTo, this.alias, true);
                this.addFinalstep(request4, new SSLSecurityBuilder.FailureDescProvider(){

                    @Override
                    public String stepFailedDescription() {
                        return "Exporting certificate " + cName + " from key-store " + InteractiveSecurityBuilder.this.keyStoreName;
                    }
                });
                ModelNode request5 = ElytronUtil.generateSigningRequest(ctx, this.keyStoreName, new File(csrName), relativeTo, this.alias);
                this.addFinalstep(request5, new SSLSecurityBuilder.FailureDescProvider(){

                    @Override
                    public String stepFailedDescription() {
                        return "Generating signing request  from key-store " + InteractiveSecurityBuilder.this.keyStoreName;
                    }
                });
            }
            if (this.clientCertificate != null) {
                this.setTrustedCertificatePath(new File(this.clientCertificate));
                this.setTrustStoreFileName(this.trustStoreFileName);
                this.setTrustStoreFilePassword(this.trustStorePassword);
                this.setValidateCertificate(this.validateCertificate);
            }
        }
        catch (Exception ex) {
            try {
                this.failureOccured(ctx, null);
            }
            catch (Exception ex2) {
                ex.addSuppressed(ex2);
            }
            throw ex;
        }
        super.buildRequest(ctx, buildRequest);
    }

    private List<String> parseEmails(String emails) {
        List<String> emailsList = this.parseItemsFromString(emails);
        ArrayList<String> urls = new ArrayList<String>();
        if (emailsList != null) {
            for (String email : emailsList) {
                if (!email.contains("@")) continue;
                urls.add("mailto:".concat(email));
            }
        }
        return urls;
    }

    private List<String> parseItemsFromString(String items) {
        List<String> itemsList = new ArrayList<String>();
        if (items != null && items.length() > 0) {
            itemsList = Arrays.asList(items.split(","));
        }
        return itemsList;
    }

    @Override
    protected KeyStore buildKeyStore(CommandContext ctx, boolean buildRequest) throws Exception {
        return new KeyStore(this.keyStoreName, this.password, this.alias, false);
    }

    @Override
    public void doFailureOccured(CommandContext ctx) throws Exception {
        if (this.keyStoreName != null) {
            ModelNode req;
            if (this.useLetsEncrypt && this.caAccount == null) {
                req = ElytronUtil.removeCertificateAuthorityAccount(this.certAuthorityAccountName);
                SecurityCommand.execute(ctx, req, SecurityCommand.DEFAULT_FAILURE_CONSUMER, false);
                req = ElytronUtil.removeKeyStore(ctx, this.accountKeyStoreName);
                SecurityCommand.execute(ctx, req, SecurityCommand.DEFAULT_FAILURE_CONSUMER, false);
            }
            req = ElytronUtil.removeKeyStore(ctx, this.keyStoreName);
            SecurityCommand.execute(ctx, req, SecurityCommand.DEFAULT_FAILURE_CONSUMER, false);
        }
    }

    private class DNWizard {
        private static final String UNKNOWN = "Unknown";
        private String name = "Unknown";
        private String orgUnit = "Unknown";
        private String org = "Unknown";
        private String city = "Unknown";
        private String state = "Unknown";
        private String countryCode = "Unknown";

        private DNWizard() {
        }

        private String buildDN() throws InterruptedException {
            String dnString = null;
            boolean correct = false;
            while (!correct) {
                this.name = this.prompt("What is your first and last name?", this.name);
                this.orgUnit = this.prompt("What is the name of your organizational unit?", this.orgUnit);
                this.org = this.prompt("What is the name of your organization?", this.org);
                this.city = this.prompt("What is the name of your City or Locality?", this.city);
                this.state = this.prompt("What is the name of your State or Province?", this.state);
                this.countryCode = this.prompt("What is the two-letter country code for this unit?", this.countryCode);
                dnString = this.buildDNString();
                String res = InteractiveSecurityBuilder.this.commandInvocation.inputLine(new Prompt("Is " + dnString + " correct y/n [y]?"));
                if (res != null && res.equals("y")) {
                    correct = true;
                    break;
                }
                if (res != null && res.equals("n")) {
                    correct = false;
                    continue;
                }
                if (res != null && res.length() == 0) {
                    correct = true;
                    break;
                }
                correct = false;
            }
            return dnString;
        }

        private String buildDNString() {
            return "CN=" + this.name + ", OU=" + this.orgUnit + ", O=" + this.org + ", L=" + this.city + ", ST=" + this.state + ", C=" + this.countryCode;
        }

        private String prompt(String prompt, String value) throws InterruptedException {
            String res = InteractiveSecurityBuilder.this.commandInvocation.inputLine(new Prompt(prompt + " [" + value + "]: "));
            if (res == null || res.length() == 0) {
                res = value;
            }
            return res;
        }
    }
}

