/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Map;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.ConnectionInfo;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.util.FingerprintGenerator;
import org.jboss.as.cli.util.SimpleTable;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public class ConnectionInfoHandler
extends CommandHandlerWithHelp {
    public ConnectionInfoHandler() {
        this("connection-info");
    }

    public ConnectionInfoHandler(String command) {
        super(command);
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandLineException {
        ModelControllerClient client = ctx.getModelControllerClient();
        if (client == null) {
            ctx.printLine("<connect to the controller and re-run the connection-info command to see the connection information>\n");
        } else {
            boolean sslConn;
            ConnectionInfo connInfo = ctx.getConnectionInfo();
            String username = null;
            ModelNode req = new ModelNode();
            req.get("operation").set("whoami");
            req.get("address").setEmptyList();
            req.get("verbose").set(true);
            try {
                ModelNode response = client.execute(req);
                if (Util.isSuccess(response)) {
                    if (response.hasDefined("result")) {
                        ModelNode result = response.get("result");
                        if (result.hasDefined("identity")) {
                            username = result.get("identity").get("username").asString();
                        }
                        if (result.hasDefined("mapped-roles")) {
                            String strRoles = result.get("mapped-roles").asString();
                            X509Certificate[] grantedStr = "granted role";
                            if (strRoles.indexOf(44) > 0) {
                                grantedStr = "granted roles";
                            }
                            username = username + ", " + (String)grantedStr + " " + strRoles;
                        } else {
                            username = username + " has no role associated.";
                        }
                    } else {
                        username = "result was not available.";
                    }
                } else {
                    ctx.printLine(Util.getFailureDescription(response));
                }
            }
            catch (IOException e) {
                throw new CommandFormatException("Failed to get the AS release info: " + e.getLocalizedMessage());
            }
            SimpleTable st = new SimpleTable(2);
            st.addLine("Username", username);
            st.addLine("Logged since", connInfo.getLoggedSince().toString());
            X509Certificate[] lastChain = connInfo.getServerCertificates();
            boolean bl = sslConn = lastChain != null;
            if (sslConn) {
                try {
                    for (X509Certificate current : lastChain) {
                        if (!(current instanceof X509Certificate)) continue;
                        X509Certificate x509Current = current;
                        Map<String, String> fingerprints = FingerprintGenerator.generateFingerprints(x509Current);
                        st.addLine("Subject", x509Current.getSubjectX500Principal().getName());
                        st.addLine("Issuer", x509Current.getIssuerDN().getName());
                        st.addLine("Valid from", x509Current.getNotBefore().toString());
                        st.addLine("Valid to", x509Current.getNotAfter().toString());
                        for (String alg : fingerprints.keySet()) {
                            st.addLine(alg, fingerprints.get(alg));
                        }
                    }
                }
                catch (CommandLineException cle) {
                    throw new CommandFormatException("Error trying to generate server certificate fingerprint.", cle);
                }
            } else {
                st.addLine("Not an SSL connection.", "");
            }
            ctx.printLine(st.toString());
        }
    }
}

