/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.operation.impl;

import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.operation.ParsedOperationRequestHeader;
import org.jboss.as.cli.operation.impl.DefaultCallbackHandler;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.as.cli.operation.impl.ParsedRolloutPlanHeader;
import org.jboss.as.cli.operation.impl.SingleRolloutPlanGroup;

public class RolloutPlanCompleter
implements CommandLineCompleter {
    public static final RolloutPlanCompleter INSTANCE = new RolloutPlanCompleter();
    private static final DefaultOperationRequestAddress address = new DefaultOperationRequestAddress();
    private final DefaultCallbackHandler parsedOp = new DefaultCallbackHandler();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
        if (!ctx.isDomainMode()) {
            return -1;
        }
        if (buffer.isEmpty()) {
            candidates.add("{rollout");
            return 0;
        }
        try {
            this.parsedOp.parseOperation(null, buffer);
        }
        catch (CommandFormatException e) {
            return -1;
        }
        if (this.parsedOp.isRequestComplete()) {
            return -1;
        }
        if (this.parsedOp.endsOnHeaderListStart() || this.parsedOp.endsOnHeaderSeparator()) {
            candidates.add("rollout");
            return this.parsedOp.getLastSeparatorIndex() + 1;
        }
        if (this.parsedOp.getLastHeader() == null) {
            if (!ctx.getParsedCommandLine().getOriginalLine().endsWith(" ")) return buffer.length();
            String originalLine = ctx.getParsedCommandLine().getOriginalLine();
            int bufferIndex = originalLine.lastIndexOf(buffer);
            if (bufferIndex == -1) {
                return -1;
            }
            candidates.add("id=");
            candidates.addAll(Util.getServerGroups(ctx.getModelControllerClient()));
            return originalLine.length() - bufferIndex;
        }
        ParsedOperationRequestHeader lastHeader = this.parsedOp.getLastHeader();
        if (!(lastHeader instanceof ParsedRolloutPlanHeader)) {
            throw new IllegalStateException("Expected " + ParsedRolloutPlanHeader.class + " but got " + lastHeader.getName() + " of " + lastHeader);
        }
        ParsedRolloutPlanHeader rollout = (ParsedRolloutPlanHeader)lastHeader;
        if (rollout.endsOnPlanIdValueSeparator()) {
            candidates.addAll(Util.getNodeNames(ctx.getModelControllerClient(), address, "rollout-plan"));
            return rollout.getLastSeparatorIndex() + 1;
        }
        String planRef = rollout.getPlanRef();
        if (planRef != null) {
            List<String> nodeNames = Util.getNodeNames(ctx.getModelControllerClient(), address, "rollout-plan");
            for (String name : nodeNames) {
                if (!name.startsWith(planRef)) continue;
                candidates.add(name);
            }
            return rollout.getLastChunkIndex();
        }
        if (rollout.hasProperties()) {
            String lastName = rollout.getLastPropertyName();
            if (!"rollback-across-groups".startsWith(lastName)) return rollout.getLastChunkIndex();
            candidates.add("rollback-across-groups");
            return rollout.getLastChunkIndex();
        }
        if (rollout.endsOnGroupSeparator()) {
            List<String> serverGroups = Util.getServerGroups(ctx.getModelControllerClient());
            for (String group : serverGroups) {
                if (rollout.containsGroup(group)) continue;
                candidates.add(group);
            }
            return buffer.length();
        }
        SingleRolloutPlanGroup lastGroup = rollout.getLastGroup();
        if (lastGroup == null) {
            return -1;
        }
        if (lastGroup.endsOnPropertyListEnd()) {
            candidates.add("^");
            candidates.add(",");
            if (Character.isWhitespace(buffer.charAt(buffer.length() - 1))) {
                candidates.add("rollback-across-groups");
            }
            candidates.add(";");
            candidates.add("}");
            return buffer.length();
        }
        if (lastGroup.endsOnPropertyListStart()) {
            candidates.add("max-failed-servers=");
            candidates.add("max-failure-percentage=");
            candidates.add("rolling-to-servers=");
            return buffer.length();
        }
        if (lastGroup.hasProperties()) {
            String propValue = lastGroup.getLastPropertyValue();
            if (propValue != null) {
                if ("true".startsWith(propValue)) {
                    candidates.add("true");
                    return lastGroup.getLastChunkIndex();
                } else {
                    if (!"false".startsWith(propValue)) return buffer.length();
                    candidates.add("false");
                }
                return lastGroup.getLastChunkIndex();
            } else {
                if (lastGroup.endsOnPropertyValueSeparator()) {
                    if (!"rolling-to-servers".equals(lastGroup.getLastPropertyName())) return buffer.length();
                    candidates.add("false");
                    candidates.add("true");
                    return buffer.length();
                }
                if (lastGroup.endsOnPropertySeparator()) {
                    if (!lastGroup.hasProperty("max-failed-servers")) {
                        candidates.add("max-failed-servers=");
                    }
                    if (!lastGroup.hasProperty("max-failure-percentage")) {
                        candidates.add("max-failure-percentage=");
                    }
                    if (lastGroup.hasProperty("rolling-to-servers")) return lastGroup.getLastSeparatorIndex() + 1;
                    candidates.add("rolling-to-servers=");
                    return lastGroup.getLastSeparatorIndex() + 1;
                }
                String propName = lastGroup.getLastPropertyName();
                if ("max-failed-servers".startsWith(propName)) {
                    candidates.add("max-failed-servers=");
                }
                if ("max-failure-percentage".startsWith(propName)) {
                    candidates.add("max-failure-percentage=");
                    return lastGroup.getLastChunkIndex();
                } else {
                    if (!"rolling-to-servers".startsWith(propName)) return lastGroup.getLastChunkIndex();
                    candidates.add("rolling-to-servers=");
                }
            }
            return lastGroup.getLastChunkIndex();
        }
        if (Character.isWhitespace(buffer.charAt(buffer.length() - 1))) {
            candidates.add("(");
            candidates.add("^");
            candidates.add(",");
            candidates.add("rollback-across-groups");
            candidates.add(";");
            candidates.add("}");
            return buffer.length();
        }
        int result = lastGroup.getLastChunkIndex();
        String groupName = lastGroup.getGroupName();
        List<String> serverGroups = Util.getServerGroups(ctx.getModelControllerClient());
        for (String group : serverGroups) {
            if (!group.startsWith(groupName)) continue;
            candidates.add(group);
        }
        if ("id".startsWith(groupName)) {
            candidates.add("id=");
            return result;
        } else {
            if (candidates.size() != 1) return result;
            String group = candidates.get(0);
            candidates.set(0, group + '(');
            candidates.add(group + ',');
            candidates.add(group + '^');
            candidates.add(group + ';');
            candidates.add(group + '}');
        }
        return result;
    }

    static {
        address.toNode("management-client-content", "rollout-plans");
    }
}

