package org.jboss.as.controller.client.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import java.io.IOException;
import org.jboss.logging.Logger;
import org.jboss.as.controller.client.helpers.domain.RollbackCancelledException;
import java.net.URI;
import java.net.URL;
import org.jboss.as.controller.client.logging.ControllerClientLogger.LeakDescription;
import org.jboss.as.controller.client.helpers.domain.DeploymentAction.Type;
import java.lang.RuntimeException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2018-11-07T09:36:05+0000")
public class ControllerClientLogger_$logger extends DelegatingBasicLogger implements ControllerClientLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ControllerClientLogger_$logger.class.getName();
    public ControllerClientLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String cannotAddDeploymentAction = "WFLYCC0001: Cannot add deployment actions after starting creation of a rollout plan";
    protected String cannotAddDeploymentAction$str() {
        return cannotAddDeploymentAction;
    }
    @Override
    public final IllegalStateException cannotAddDeploymentAction() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotAddDeploymentAction$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotAddDeploymentActionsAfterStart = "WFLYCC0002: Cannot add deployment actions after starting creation of a rollout plan";
    protected String cannotAddDeploymentActionsAfterStart$str() {
        return cannotAddDeploymentActionsAfterStart;
    }
    @Override
    public final IllegalStateException cannotAddDeploymentActionsAfterStart() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotAddDeploymentActionsAfterStart$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotConvert = "WFLYCC0003: Cannot convert %s to %s";
    protected String cannotConvert$str() {
        return cannotConvert;
    }
    @Override
    public final String cannotConvert(final String first, final String second) {
        return String.format(getLoggingLocale(), cannotConvert$str(), first, second);
    }
    private static final String cannotDeriveDeploymentName = "WFLYCC0004: Cannot derive a deployment name from %s -- use an overloaded method variant that takes a 'name' parameter";
    protected String cannotDeriveDeploymentName$str() {
        return cannotDeriveDeploymentName;
    }
    @Override
    public final IllegalArgumentException cannotDeriveDeploymentName(final URL url) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotDeriveDeploymentName$str(), url));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotUseDeploymentPlan = "WFLYCC0005: Cannot use a DeploymentPlan not created by this manager";
    protected String cannotUseDeploymentPlan$str() {
        return cannotUseDeploymentPlan;
    }
    @Override
    public final IllegalArgumentException cannotUseDeploymentPlan() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotUseDeploymentPlan$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String domainDeploymentAlreadyExists = "WFLYCC0007: Deployment with name %s already present in the domain";
    protected String domainDeploymentAlreadyExists$str() {
        return domainDeploymentAlreadyExists;
    }
    @Override
    public final String domainDeploymentAlreadyExists(final String name) {
        return String.format(getLoggingLocale(), domainDeploymentAlreadyExists$str(), name);
    }
    private static final String failed = "WFLYCC0008: failed";
    protected String failed$str() {
        return failed;
    }
    @Override
    public final String failed() {
        return String.format(getLoggingLocale(), failed$str());
    }
    private static final String globalRollbackNotCompatible = "WFLYCC0009: Global rollback is not compatible with a server restart";
    protected String globalRollbackNotCompatible$str() {
        return globalRollbackNotCompatible;
    }
    @Override
    public final IllegalStateException globalRollbackNotCompatible() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), globalRollbackNotCompatible$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String gracefulShutdownAlreadyConfigured = "WFLYCC0010: Graceful shutdown already configured with a timeout of %d ms";
    protected String gracefulShutdownAlreadyConfigured$str() {
        return gracefulShutdownAlreadyConfigured;
    }
    @Override
    public final IllegalStateException gracefulShutdownAlreadyConfigured(final long timeout) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), gracefulShutdownAlreadyConfigured$str(), timeout));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String incompleteDeploymentReplace = "WFLYCC0011: Only one version of deployment with a given unique name can exist in the domain. The deployment plan specified that a new version of deployment %s replace an existing deployment with the same unique name, but did not apply the replacement to all server groups. Missing server groups were: %s";
    protected String incompleteDeploymentReplace$str() {
        return incompleteDeploymentReplace;
    }
    @Override
    public final String incompleteDeploymentReplace(final String deploymentName, final String missingGroups) {
        return String.format(getLoggingLocale(), incompleteDeploymentReplace$str(), deploymentName, missingGroups);
    }
    private static final String invalidActionType = "WFLYCC0012: Invalid action type %s";
    protected String invalidActionType$str() {
        return invalidActionType;
    }
    @Override
    public final IllegalStateException invalidActionType(final Type type) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), invalidActionType$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidPrecedingAction = "WFLYCC0013: Preceding action was not a %s";
    protected String invalidPrecedingAction$str() {
        return invalidPrecedingAction;
    }
    @Override
    public final IllegalStateException invalidPrecedingAction(final Object type) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), invalidPrecedingAction$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidUri = "WFLYCC0014: %s is not a valid URI";
    protected String invalidUri$str() {
        return invalidUri;
    }
    @Override
    public final IllegalArgumentException invalidUri(final Throwable cause, final URL url) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidUri$str(), url), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidValue3 = "WFLYCC0015: Illegal %s value %d -- must be greater than %d";
    protected String invalidValue3$str() {
        return invalidValue3;
    }
    @Override
    public final IllegalArgumentException invalidValue(final String name, final int value, final int minValue) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidValue3$str(), name, value, minValue));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidValue4 = "WFLYCC0016: Illegal %s value %d -- must be greater than %d and less than %d";
    protected String invalidValue4$str() {
        return invalidValue4;
    }
    @Override
    public final IllegalArgumentException invalidValue(final String name, final int value, final int minValue, final int maxValue) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidValue4$str(), name, value, minValue, maxValue));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String maxDisplayUnitLength = "WFLYCC0017: Screen real estate is expensive; displayUnits must be 5 characters or less";
    protected String maxDisplayUnitLength$str() {
        return maxDisplayUnitLength;
    }
    @Override
    public final RuntimeException maxDisplayUnitLength() {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), maxDisplayUnitLength$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noFailureDetails = "WFLYCC0019: No failure details provided";
    protected String noFailureDetails$str() {
        return noFailureDetails;
    }
    @Override
    public final String noFailureDetails() {
        return String.format(getLoggingLocale(), noFailureDetails$str());
    }
    private static final String notConfigured = "WFLYCC0020: No %s is configured";
    protected String notConfigured$str() {
        return notConfigured;
    }
    @Override
    public final IllegalStateException notConfigured(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), notConfigured$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String objectIsClosed = "WFLYCC0022: %s is closed";
    protected String objectIsClosed$str() {
        return objectIsClosed;
    }
    @Override
    public final IllegalStateException objectIsClosed(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), objectIsClosed$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String operationOutcome = "WFLYCC0023: Operation outcome is %s";
    protected String operationOutcome$str() {
        return operationOutcome;
    }
    @Override
    public final RuntimeException operationOutcome(final String outcome) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), operationOutcome$str(), outcome));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String operationsNotAllowed = "WFLYCC0024: %s operations are not allowed after content and deployment modifications";
    protected String operationsNotAllowed$str() {
        return operationsNotAllowed;
    }
    @Override
    public final IllegalStateException operationsNotAllowed(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), operationsNotAllowed$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String rollbackCancelled = "WFLYCC0025: Rollback was cancelled";
    protected String rollbackCancelled$str() {
        return rollbackCancelled;
    }
    @Override
    public final RollbackCancelledException rollbackCancelled() {
        final RollbackCancelledException result = new RollbackCancelledException(String.format(getLoggingLocale(), rollbackCancelled$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String rollbackRolledBack = "WFLYCC0026: Rollback was itself rolled back";
    protected String rollbackRolledBack$str() {
        return rollbackRolledBack;
    }
    @Override
    public final RollbackCancelledException rollbackRolledBack() {
        final RollbackCancelledException result = new RollbackCancelledException(String.format(getLoggingLocale(), rollbackRolledBack$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String rollbackTimedOut = "WFLYCC0027: Rollback timed out";
    protected String rollbackTimedOut$str() {
        return rollbackTimedOut;
    }
    @Override
    public final RollbackCancelledException rollbackTimedOut() {
        final RollbackCancelledException result = new RollbackCancelledException(String.format(getLoggingLocale(), rollbackTimedOut$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serverDeploymentAlreadyExists = "WFLYCC0028: Deployment with name %s already present in the server";
    protected String serverDeploymentAlreadyExists$str() {
        return serverDeploymentAlreadyExists;
    }
    @Override
    public final String serverDeploymentAlreadyExists(final String name) {
        return String.format(getLoggingLocale(), serverDeploymentAlreadyExists$str(), name);
    }
    private static final String unknownActionType = "WFLYCC0029: Unknown action type %s";
    protected String unknownActionType$str() {
        return unknownActionType;
    }
    @Override
    public final IllegalStateException unknownActionType(final Object type) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unknownActionType$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String controllerClientNotClosed = "WFLYCC0030: Allocation stack trace:";
    protected String controllerClientNotClosed$str() {
        return controllerClientNotClosed;
    }
    @Override
    public final LeakDescription controllerClientNotClosed() {
        final LeakDescription result = new LeakDescription(String.format(getLoggingLocale(), controllerClientNotClosed$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noFailureDescription = "WFLYCC0031: No failure description as the operation was successful.";
    protected String noFailureDescription$str() {
        return noFailureDescription;
    }
    @Override
    public final IllegalArgumentException noFailureDescription() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noFailureDescription$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String operationNameNotFound = "WFLYCC0032: The operation name was not defined.";
    protected String operationNameNotFound$str() {
        return operationNameNotFound;
    }
    @Override
    public final IllegalArgumentException operationNameNotFound() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), operationNameNotFound$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidAddressType = "WFLYCC0033: The address must be of type ModelType.LIST.";
    protected String invalidAddressType$str() {
        return invalidAddressType;
    }
    @Override
    public final IllegalArgumentException invalidAddressType() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidAddressType$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void leakedControllerClient(final Throwable allocationStackTrace) {
        super.log.logf(FQCN, WARN, allocationStackTrace, leakedControllerClient$str());
    }
    private static final String leakedControllerClient = "WFLYCC0034: Closing leaked controller client";
    protected String leakedControllerClient$str() {
        return leakedControllerClient;
    }
    @Override
    public final void cannotDeleteTempFile(final String name) {
        super.log.logf(FQCN, WARN, null, cannotDeleteTempFile$str(), name);
    }
    private static final String cannotDeleteTempFile = "WFLYCC0035: Cannot delete temp file %s, will be deleted on exit";
    protected String cannotDeleteTempFile$str() {
        return cannotDeleteTempFile;
    }
    private static final String streamWasClosed = "WFLYCC0036: Stream was closed";
    protected String streamWasClosed$str() {
        return streamWasClosed;
    }
    @Override
    public final IOException streamWasClosed() {
        final IOException result = new IOException(String.format(getLoggingLocale(), streamWasClosed$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToParseAuthenticationConfig = "WFLYCC0037: Failed to parse the configuration file: %s";
    protected String failedToParseAuthenticationConfig$str() {
        return failedToParseAuthenticationConfig;
    }
    @Override
    public final RuntimeException failedToParseAuthenticationConfig(final Throwable cause, final URI location) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failedToParseAuthenticationConfig$str(), location), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
