/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import org.jboss.as.controller.security.ControllerPermission;
import org.jboss.as.core.security.AccessMechanism;
import org.wildfly.security.manager.WildFlySecurityManager;

public class AccessAuditContext {
    private static ThreadLocal<AccessAuditContext> contextThreadLocal = new ThreadLocal();
    private String domainUuid;
    private AccessMechanism accessMechanism;

    private AccessAuditContext() {
    }

    public String getDomainUuid() {
        return this.domainUuid;
    }

    public void setDomainUuid(String domainUuid) {
        this.domainUuid = domainUuid;
    }

    public AccessMechanism getAccessMechanism() {
        return this.accessMechanism;
    }

    public void setAccessMechanism(AccessMechanism accessMechanism) {
        this.accessMechanism = accessMechanism;
    }

    @Deprecated
    public static AccessAuditContext currentAccessAuditContext() {
        if (WildFlySecurityManager.isChecking()) {
            System.getSecurityManager().checkPermission(ControllerPermission.GET_CURRENT_ACCESS_AUDIT_CONTEXT);
        }
        return contextThreadLocal.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doAs(Subject subject, PrivilegedAction<T> action) {
        AccessAuditContext previous = contextThreadLocal.get();
        try {
            contextThreadLocal.set(new AccessAuditContext());
            T t = Subject.doAs(subject, action);
            return t;
        }
        finally {
            contextThreadLocal.set(previous);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doAs(Subject subject, PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        AccessAuditContext previous = contextThreadLocal.get();
        try {
            contextThreadLocal.set(new AccessAuditContext());
            T t = Subject.doAs(subject, action);
            return t;
        }
        finally {
            contextThreadLocal.set(previous);
        }
    }
}

