/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.capability.registry;

import org.jboss.as.controller.capability.registry.CapabilityContext;
import org.jboss.as.controller.capability.registry.CapabilityId;

public class RequirementRegistration {
    private final String requiredName;
    private final CapabilityId dependentId;

    public RequirementRegistration(String requiredName, String dependentName, CapabilityContext dependentContext) {
        this(requiredName, new CapabilityId(dependentName, dependentContext));
    }

    protected RequirementRegistration(String requiredName, CapabilityId dependentId) {
        this.requiredName = requiredName;
        this.dependentId = dependentId;
    }

    public String getRequiredName() {
        return this.requiredName;
    }

    public String getDependentName() {
        return this.dependentId.getName();
    }

    public CapabilityContext getDependentContext() {
        return this.dependentId.getContext();
    }

    public CapabilityId getDependentId() {
        return this.dependentId;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().isAssignableFrom(o.getClass())) {
            return false;
        }
        RequirementRegistration that = (RequirementRegistration)o;
        return this.dependentId.equals(that.dependentId) && this.requiredName.equals(that.requiredName);
    }

    public final int hashCode() {
        int result = this.requiredName.hashCode();
        result = 31 * result + this.dependentId.hashCode();
        return result;
    }
}

