/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;

public abstract class ProcessReloadHandler<T extends RunningModeControl>
implements OperationStepHandler {
    protected static final String OPERATION_NAME = "reload";
    protected static final AttributeDefinition ADMIN_ONLY = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("admin-only", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(false))).build();
    private final T runningModeControl;
    private final ControlledProcessState processState;
    private final ServiceName rootService;

    public ProcessReloadHandler(ServiceName rootService, T runningModeControl, ControlledProcessState processState) {
        this.rootService = rootService;
        this.runningModeControl = runningModeControl;
        this.processState = processState;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            @Override
            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                final ReloadContext reloadContext = ProcessReloadHandler.this.initializeReloadContext(context, operation);
                final ServiceController service = context.getServiceRegistry(true).getRequiredService(ProcessReloadHandler.this.rootService);
                context.completeStep(new OperationContext.ResultHandler(){

                    @Override
                    public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                        if (resultAction == OperationContext.ResultAction.KEEP) {
                            service.addListener((ServiceListener)new AbstractServiceListener<Object>(){

                                public void listenerAdded(ServiceController<?> controller) {
                                    reloadContext.reloadInitiated(ProcessReloadHandler.this.runningModeControl);
                                    ProcessReloadHandler.this.processState.setStopping();
                                    controller.setMode(ServiceController.Mode.NEVER);
                                }

                                public void transition(ServiceController<? extends Object> controller, ServiceController.Transition transition) {
                                    if (transition == ServiceController.Transition.STOPPING_to_DOWN) {
                                        controller.removeListener((ServiceListener)this);
                                        reloadContext.doReload(ProcessReloadHandler.this.runningModeControl);
                                        controller.setMode(ServiceController.Mode.ACTIVE);
                                    }
                                }
                            });
                        }
                    }
                });
            }
        }, OperationContext.Stage.RUNTIME);
    }

    protected abstract ReloadContext<T> initializeReloadContext(OperationContext var1, ModelNode var2) throws OperationFailedException;

    protected static interface ReloadContext<T> {
        public void reloadInitiated(T var1);

        public void doReload(T var1);
    }
}

