/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.registry;

import java.util.NoSuchElementException;
import java.util.Set;
import org.jboss.as.controller.OperationClientException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.BasicResource;
import org.jboss.as.controller.registry.ResourceFilter;
import org.jboss.dmr.ModelNode;

public interface Resource
extends Cloneable {
    public ModelNode getModel();

    public void writeModel(ModelNode var1);

    public boolean isModelDefined();

    public boolean hasChild(PathElement var1);

    public Resource getChild(PathElement var1);

    public Resource requireChild(PathElement var1);

    public boolean hasChildren(String var1);

    public Resource navigate(PathAddress var1);

    public Set<String> getChildTypes();

    public Set<String> getChildrenNames(String var1);

    public Set<ResourceEntry> getChildren(String var1);

    public void registerChild(PathElement var1, Resource var2);

    public void registerChild(PathElement var1, int var2, Resource var3);

    public Resource removeChild(PathElement var1);

    public Set<String> getOrderedChildTypes();

    public boolean isRuntime();

    public boolean isProxy();

    public Resource clone();

    public static class NoSuchResourceException
    extends NoSuchElementException
    implements OperationClientException {
        private static final long serialVersionUID = -2409240663987141424L;

        public NoSuchResourceException(PathElement childPath) {
            this(ControllerLogger.ROOT_LOGGER.childResourceNotFound(childPath));
        }

        public NoSuchResourceException(String message) {
            super(message);
        }

        @Override
        public ModelNode getFailureDescription() {
            return new ModelNode(this.getLocalizedMessage());
        }

        @Override
        public String toString() {
            return super.toString() + " [ " + this.getFailureDescription() + " ]";
        }
    }

    public static class Tools {
        public static final ResourceFilter ALL_BUT_RUNTIME_AND_PROXIES_FILTER = new ResourceFilter(){

            @Override
            public boolean accepts(PathAddress address, Resource resource) {
                return !resource.isRuntime() && !resource.isProxy();
            }
        };

        private Tools() {
        }

        public static ModelNode readModel(Resource resource) {
            return Tools.readModel(resource, -1);
        }

        public static ModelNode readModel(Resource resource, int level) {
            return Tools.readModel(resource, level, ALL_BUT_RUNTIME_AND_PROXIES_FILTER);
        }

        public static ModelNode readModel(Resource resource, int level, ResourceFilter filter) {
            if (filter.accepts(PathAddress.EMPTY_ADDRESS, resource)) {
                return Tools.readModel(PathAddress.EMPTY_ADDRESS, resource, level, filter);
            }
            return new ModelNode();
        }

        static ModelNode readModel(PathAddress address, Resource resource, int level, ResourceFilter filter) {
            boolean recursive;
            ModelNode model = resource.getModel().clone();
            boolean bl = level == -1 ? true : (recursive = level > 0);
            if (recursive) {
                int newLevel = level == -1 ? -1 : level - 1;
                for (String childType : resource.getChildTypes()) {
                    model.get(childType).setEmptyObject();
                    for (ResourceEntry entry : resource.getChildren(childType)) {
                        if (!filter.accepts(address.append(entry.getPathElement()), resource)) continue;
                        model.get(new String[]{childType, entry.getName()}).set(Tools.readModel(entry, newLevel));
                    }
                }
            }
            return model;
        }

        public static Resource navigate(Resource resource, PathAddress address) {
            Resource r = resource;
            for (PathElement element : address) {
                r = r.requireChild(element);
            }
            return r;
        }
    }

    public static class Factory {
        private Factory() {
        }

        public static Resource create() {
            return new BasicResource();
        }

        public static Resource create(boolean runtimeOnly) {
            return new BasicResource(runtimeOnly);
        }

        public static Resource create(boolean runtimeOnly, Set<String> orderedChildTypes) {
            return new BasicResource(runtimeOnly, orderedChildTypes);
        }
    }

    public static interface ResourceEntry
    extends Resource {
        public String getName();

        public PathElement getPathElement();
    }
}

