/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.audit;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.jboss.as.controller.audit.AbstractFileAuditLogHandler;
import org.jboss.as.controller.audit.AuditLogHandler;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.services.path.PathManagerService;

public class PeriodicRotatingFileAuditLogHandler
extends AbstractFileAuditLogHandler {
    private SimpleDateFormat format;
    private Period period = Period.NEVER;
    private volatile String nextSuffix;
    private volatile long nextRollover = Long.MAX_VALUE;
    private TimeZone timeZone = TimeZone.getDefault();
    private String suffix;

    public PeriodicRotatingFileAuditLogHandler(String name, String formatterName, int maxFailureCount, PathManagerService pathManager, String path, String relativeTo, String suffix, TimeZone timeZone) {
        super(name, formatterName, maxFailureCount, pathManager, path, relativeTo);
        this.suffix = suffix;
        if (timeZone != null) {
            this.timeZone = timeZone;
        }
        this.setSuffix(suffix);
    }

    @Override
    protected void initializeAtStartup(File file) {
        long lastModified = file.lastModified();
        this.calcNextRollover(lastModified > 0L ? lastModified : System.currentTimeMillis());
    }

    @Override
    protected void rotateLogFile(File file) {
        long now = System.currentTimeMillis();
        if (now >= this.nextRollover) {
            this.rollOver(file);
            this.calcNextRollover(now);
        }
    }

    private void setSuffix(String suffix) throws IllegalArgumentException {
        SimpleDateFormat format = new SimpleDateFormat(suffix);
        format.setTimeZone(this.timeZone);
        int len = suffix.length();
        Period period = Period.NEVER;
        block11: for (int i = 0; i < len; ++i) {
            switch (suffix.charAt(i)) {
                case 'y': {
                    period = PeriodicRotatingFileAuditLogHandler.min(period, Period.YEAR);
                    continue block11;
                }
                case 'M': {
                    period = PeriodicRotatingFileAuditLogHandler.min(period, Period.MONTH);
                    continue block11;
                }
                case 'W': 
                case 'w': {
                    period = PeriodicRotatingFileAuditLogHandler.min(period, Period.WEEK);
                    continue block11;
                }
                case 'D': 
                case 'E': 
                case 'F': 
                case 'd': {
                    period = PeriodicRotatingFileAuditLogHandler.min(period, Period.DAY);
                    continue block11;
                }
                case 'a': {
                    period = PeriodicRotatingFileAuditLogHandler.min(period, Period.HALF_DAY);
                    continue block11;
                }
                case 'H': 
                case 'K': 
                case 'h': 
                case 'k': {
                    period = PeriodicRotatingFileAuditLogHandler.min(period, Period.HOUR);
                    continue block11;
                }
                case 'm': {
                    period = PeriodicRotatingFileAuditLogHandler.min(period, Period.MINUTE);
                    continue block11;
                }
                case '\'': {
                    while (suffix.charAt(++i) != '\'') {
                    }
                    continue block11;
                }
                case 'S': 
                case 's': {
                    throw new IllegalArgumentException("Rotating by second or millisecond is not supported");
                }
            }
        }
        this.format = format;
        this.period = period;
    }

    private void rollOver(File file) {
        File backup = new File(file.getParentFile(), file.getName() + this.nextSuffix);
        try {
            this.rename(file, backup);
        }
        catch (IOException e) {
            throw ControllerLogger.ROOT_LOGGER.couldNotBackUp(e, file.getAbsolutePath(), backup.getAbsolutePath());
        }
        this.createNewFile(file);
    }

    private void calcNextRollover(long fromTime) {
        if (this.period == Period.NEVER) {
            this.nextRollover = Long.MAX_VALUE;
            return;
        }
        this.nextSuffix = this.format.format(new Date(fromTime));
        Calendar calendar = Calendar.getInstance(this.timeZone);
        calendar.setTimeInMillis(fromTime);
        Period period = this.period;
        switch (period) {
            default: {
                calendar.set(2, 0);
            }
            case MONTH: {
                calendar.set(5, 0);
                calendar.clear(4);
            }
            case WEEK: {
                if (period == Period.WEEK) {
                    calendar.set(7, 0);
                } else {
                    calendar.clear(7);
                }
                calendar.clear(8);
            }
            case DAY: {
                calendar.set(11, 0);
            }
            case HALF_DAY: {
                calendar.set(10, 0);
            }
            case HOUR: {
                calendar.set(12, 0);
            }
            case MINUTE: 
        }
        calendar.set(13, 0);
        calendar.set(14, 0);
        switch (period) {
            case YEAR: {
                calendar.add(1, 1);
                break;
            }
            case MONTH: {
                calendar.add(2, 1);
                break;
            }
            case WEEK: {
                calendar.add(3, 1);
                break;
            }
            case DAY: {
                calendar.add(5, 1);
                break;
            }
            case HALF_DAY: {
                calendar.add(9, 1);
                break;
            }
            case HOUR: {
                calendar.add(11, 1);
                break;
            }
            case MINUTE: {
                calendar.add(12, 1);
            }
        }
        this.nextRollover = calendar.getTimeInMillis();
    }

    @Override
    boolean isDifferent(AuditLogHandler other) {
        if (!(other instanceof PeriodicRotatingFileAuditLogHandler)) {
            return true;
        }
        PeriodicRotatingFileAuditLogHandler otherHandler = (PeriodicRotatingFileAuditLogHandler)other;
        if (!this.suffix.equals(otherHandler.suffix)) {
            return true;
        }
        if (!this.timeZone.equals(otherHandler.timeZone)) {
            return true;
        }
        return super.isDifferent(other);
    }

    private static <T extends Comparable<? super T>> T min(T a, T b) {
        return a.compareTo(b) <= 0 ? a : b;
    }

    public static enum Period {
        MINUTE,
        HOUR,
        HALF_DAY,
        DAY,
        WEEK,
        MONTH,
        YEAR,
        NEVER;

    }
}

