/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.connections.ldap;

import java.net.URI;
import java.util.Hashtable;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.net.ssl.SSLContext;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionManager;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionManagerRegistry;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionResourceDefinition;
import org.jboss.as.domain.management.connections.ldap.ThreadLocalSSLSocketFactory;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.security.password.interfaces.ClearPassword;

public class LdapConnectionManagerService
implements Service<LdapConnectionManager>,
LdapConnectionManager {
    private static final ServiceName BASE_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"server", "controller", "management", "connection_manager"});
    private final LdapConnectionManagerRegistry connectionManagerRegistry;
    private final String name;
    private final Consumer<LdapConnectionManager> ldapConnectionManagerConsumer;
    private final Supplier<SSLContext> fullSSLContextSupplier;
    private final Supplier<SSLContext> trustSSLContextSupplier;
    private final ExceptionSupplier<CredentialSource, Exception> credentialSourceSupplier;
    private volatile Config configuration;
    private volatile Hashtable<String, String> properties = new Hashtable();

    LdapConnectionManagerService(Consumer<LdapConnectionManager> ldapConnectionManagerConsumer, Supplier<SSLContext> fullSSLContextSupplier, Supplier<SSLContext> trustSSLContextSupplier, ExceptionSupplier<CredentialSource, Exception> credentialSourceSupplier, String name, LdapConnectionManagerRegistry connectionManagerRegistry) {
        this.ldapConnectionManagerConsumer = ldapConnectionManagerConsumer;
        this.fullSSLContextSupplier = fullSSLContextSupplier;
        this.trustSSLContextSupplier = trustSSLContextSupplier;
        this.credentialSourceSupplier = credentialSourceSupplier;
        this.name = name;
        this.connectionManagerRegistry = connectionManagerRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Config setConfiguration(String initialContextFactory, String url, String searchDn, String searchCredential, LdapConnectionResourceDefinition.ReferralHandling referralHandling, Set<URI> referralURIs, boolean alwaysSendClientCert) {
        Config configuration = new Config(initialContextFactory, url, searchDn, searchCredential, referralHandling, referralURIs, alwaysSendClientCert);
        try {
            Config config = this.configuration;
            return config;
        }
        finally {
            this.configuration = configuration;
        }
    }

    void setConfiguration(Config configuration) {
        this.configuration = configuration;
    }

    public LdapConnectionManager getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void start(final StartContext context) throws StartException {
        try {
            context.execute(new Runnable(){

                @Override
                public void run() {
                    LdapConnectionManagerService.this.connectionManagerRegistry.addLdapConnectionManagerService(LdapConnectionManagerService.this.name, LdapConnectionManagerService.this);
                    LdapConnectionManagerService.this.ldapConnectionManagerConsumer.accept(LdapConnectionManagerService.this);
                    context.complete();
                }
            });
        }
        finally {
            context.asynchronous();
        }
    }

    public void stop(final StopContext context) {
        try {
            context.execute(new Runnable(){

                @Override
                public void run() {
                    LdapConnectionManagerService.this.connectionManagerRegistry.removeLdapConnectionManagerService(LdapConnectionManagerService.this.name);
                    LdapConnectionManagerService.this.ldapConnectionManagerConsumer.accept(null);
                    context.complete();
                }
            });
        }
        finally {
            context.asynchronous();
        }
    }

    synchronized void setProperty(String name, String value) {
        Hashtable<String, String> properties = new Hashtable<String, String>(this.properties);
        properties.put(name, value);
        this.properties = properties;
    }

    synchronized void removeProperty(String name) {
        Hashtable<String, String> properties = new Hashtable<String, String>(this.properties);
        properties.remove(name);
        this.properties = properties;
    }

    void setPropertyImmediate(String name, String value) {
        this.properties.put(name, value);
    }

    String getName() {
        return this.name;
    }

    boolean handlesReferralFor(URI uri) {
        return this.configuration.getReferralURIs().contains(uri);
    }

    @Override
    public DirContext getConnection() throws NamingException {
        return this.getConnection(this.configuration);
    }

    private DirContext getConnection(Config configuration) throws NamingException {
        return this.getConnection(this.getFullProperties(configuration), this.getSSLContext(false));
    }

    @Override
    public void verifyIdentity(String bindDn, String bindCredential) throws NamingException {
        this.verifyIdentity(this.configuration, bindDn, bindCredential);
    }

    private void verifyIdentity(Config configuration, String bindDn, String bindCredential) throws NamingException {
        Hashtable<String, String> connectionProperties = this.getConnectionOnlyProperties(configuration);
        connectionProperties.put("java.naming.security.principal", bindDn);
        connectionProperties.put("java.naming.security.credentials", bindCredential);
        boolean trustOnly = !configuration.isAlwaysSendClientCert();
        DomainManagementLogger.SECURITY_LOGGER.tracef("Using a %s SSL context to authenticate user %s", trustOnly ? "trustOnly" : "fullSSLContext", bindDn);
        DirContext context = this.getConnection(connectionProperties, this.getSSLContext(trustOnly));
        context.close();
    }

    @Override
    public LdapConnectionManager findForReferral(final URI referralUri) {
        Config config = this.configuration;
        switch (config.referralHandling) {
            case FOLLOW: {
                return new LdapConnectionManager(){

                    @Override
                    public void verifyIdentity(String bindDn, String bindCredential) throws NamingException {
                        LdapConnectionManagerService.this.verifyIdentity(new Config(referralUri.toString(), LdapConnectionManagerService.this.configuration), bindDn, bindCredential);
                    }

                    @Override
                    public DirContext getConnection() throws NamingException {
                        return LdapConnectionManagerService.this.getConnection(new Config(referralUri.toString(), LdapConnectionManagerService.this.configuration));
                    }

                    @Override
                    public LdapConnectionManager findForReferral(URI referralUri2) {
                        return LdapConnectionManagerService.this.findForReferral(referralUri2);
                    }
                };
            }
            case THROW: {
                if (this.handlesReferralFor(referralUri)) {
                    return this;
                }
                for (LdapConnectionManagerService current : this.connectionManagerRegistry.availableServices()) {
                    if (current == null || !current.handlesReferralFor(referralUri)) continue;
                    return current;
                }
                break;
            }
            default: {
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirContext getConnection(Hashtable<String, String> properties, SSLContext sslContext) throws NamingException {
        ClassLoader old = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            if (sslContext != null) {
                ThreadLocalSSLSocketFactory.setSSLSocketFactory(sslContext.getSocketFactory());
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged(ThreadLocalSSLSocketFactory.class);
                properties.put("java.naming.ldap.factory.socket", ThreadLocalSSLSocketFactory.class.getName());
            }
            if (DomainManagementLogger.SECURITY_LOGGER.isTraceEnabled()) {
                Hashtable<String, String> logProperties;
                if (properties.containsKey("java.naming.security.credentials")) {
                    logProperties = new Hashtable<String, String>(properties);
                    logProperties.put("java.naming.security.credentials", "***");
                } else {
                    logProperties = properties;
                }
                DomainManagementLogger.SECURITY_LOGGER.tracef("Connecting to LDAP with properties (%s)", logProperties.toString());
            }
            InitialDirContext initialDirContext = new InitialDirContext(properties);
            return initialDirContext;
        }
        finally {
            if (sslContext != null) {
                ThreadLocalSSLSocketFactory.removeSSLSocketFactory();
            }
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)old);
        }
    }

    private SSLContext getSSLContext(boolean trustOnly) {
        SSLContext sslContext;
        if (trustOnly) {
            return this.trustSSLContextSupplier != null ? this.trustSSLContextSupplier.get() : null;
        }
        SSLContext sSLContext = sslContext = this.fullSSLContextSupplier != null ? this.fullSSLContextSupplier.get() : null;
        if (sslContext == null) {
            sslContext = this.trustSSLContextSupplier != null ? this.trustSSLContextSupplier.get() : null;
        }
        return sslContext;
    }

    private Hashtable<String, String> getConnectionOnlyProperties(Config configuration) {
        Hashtable<String, String> result = new Hashtable<String, String>(this.properties);
        result.put("java.naming.factory.initial", configuration.initialContextFactory);
        result.put("java.naming.provider.url", configuration.url);
        result.put("java.naming.referral", configuration.referralHandling.getValue());
        return result;
    }

    private Hashtable<String, String> getFullProperties(Config configuration) {
        String resolvedSearchCredential;
        Hashtable<String, String> result = this.getConnectionOnlyProperties(configuration);
        if (configuration.searchDn != null) {
            result.put("java.naming.security.principal", configuration.searchDn);
        }
        if ((resolvedSearchCredential = this.resolveSearchCredential()) != null) {
            result.put("java.naming.security.credentials", resolvedSearchCredential);
        }
        return result;
    }

    private String resolveSearchCredential() {
        try {
            ClearPassword password;
            PasswordCredential credential;
            CredentialSource cs;
            ExceptionSupplier<CredentialSource, Exception> sourceSupplier = this.credentialSourceSupplier;
            if (sourceSupplier != null && (cs = (CredentialSource)sourceSupplier.get()) != null && (credential = (PasswordCredential)cs.getCredential(PasswordCredential.class)) != null && (password = (ClearPassword)credential.getPassword(ClearPassword.class)) != null) {
                return new String(password.getPassword());
            }
        }
        catch (Exception ex) {
            return this.configuration.searchCredential;
        }
        return this.configuration.searchCredential;
    }

    static class Config {
        private final String initialContextFactory;
        private final String url;
        private final String searchDn;
        private final String searchCredential;
        private final LdapConnectionResourceDefinition.ReferralHandling referralHandling;
        private final Set<URI> referralURIs;
        private final boolean alwaysSendClientCert;

        private Config(String initialContextFactory, String url, String searchDn, String searchCredential, LdapConnectionResourceDefinition.ReferralHandling referralHandling, Set<URI> referralURIs, boolean alwaysSendClientCert) {
            this.initialContextFactory = initialContextFactory;
            this.url = url;
            this.searchDn = searchDn;
            this.searchCredential = searchCredential;
            this.referralHandling = referralHandling;
            this.referralURIs = referralURIs;
            this.alwaysSendClientCert = alwaysSendClientCert;
        }

        private Config(String url, Config config) {
            this.url = url;
            this.initialContextFactory = config.initialContextFactory;
            this.searchDn = config.searchDn;
            this.searchCredential = config.searchCredential;
            this.referralHandling = config.referralHandling;
            this.referralURIs = config.referralURIs;
            this.alwaysSendClientCert = config.alwaysSendClientCert;
        }

        public String getInitialContextFactory() {
            return this.initialContextFactory;
        }

        public String getUrl() {
            return this.url;
        }

        public String getSearchDn() {
            return this.searchDn;
        }

        public String getSearchCredential() {
            return this.searchCredential;
        }

        public LdapConnectionResourceDefinition.ReferralHandling getReferralHandling() {
            return this.referralHandling;
        }

        public Set<URI> getReferralURIs() {
            return this.referralURIs;
        }

        public boolean isAlwaysSendClientCert() {
            return this.alwaysSendClientCert;
        }
    }

    public static final class ServiceUtil {
        private ServiceUtil() {
        }

        public static ServiceName createServiceName(String connectionName) {
            return BASE_SERVICE_NAME.append(new String[]{connectionName});
        }

        public static Supplier<LdapConnectionManager> requires(ServiceBuilder<?> sb, String connectionName) {
            return sb.requires(ServiceUtil.createServiceName(connectionName));
        }
    }
}

