/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management;

import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.jboss.as.domain.management.AuthMechanism;
import org.jboss.as.domain.management.AuthorizingCallbackHandler;
import org.jboss.as.domain.management.CallbackHandlerFactory;
import org.jboss.as.domain.management.SubjectIdentity;
import org.jboss.as.domain.management.security.SecurityRealmResourceDefinition;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.wildfly.security.auth.server.HttpAuthenticationFactory;
import org.wildfly.security.auth.server.SaslAuthenticationFactory;

public interface SecurityRealm {
    public String getName();

    public Set<AuthMechanism> getSupportedAuthenticationMechanisms();

    public Map<String, String> getMechanismConfig(AuthMechanism var1);

    public AuthorizingCallbackHandler getAuthorizingCallbackHandler(AuthMechanism var1);

    public boolean isReadyForHttpChallenge();

    public SSLContext getSSLContext();

    public CallbackHandlerFactory getSecretCallbackHandlerFactory();

    public SubjectIdentity getSubjectIdentity(String var1, String var2);

    public SaslAuthenticationFactory getSaslAuthenticationFactory();

    public SaslAuthenticationFactory getSaslAuthenticationFactory(String[] var1, Boolean var2) throws StartException;

    public HttpAuthenticationFactory getHttpAuthenticationFactory();

    public static final class ServiceUtil {
        private static final ServiceName BASE_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"server", "controller", "management", "security_realm"});

        private ServiceUtil() {
        }

        public static ServiceName createLegacyServiceName(String realmName) {
            return BASE_SERVICE_NAME.append(new String[]{realmName});
        }

        public static ServiceName createServiceName(String realmName) {
            return SecurityRealmResourceDefinition.MANAGEMENT_SECURITY_REALM_CAPABILITY.getCapabilityServiceName(new String[]{realmName});
        }

        @Deprecated
        public static ServiceBuilder<?> addDependency(ServiceBuilder<?> sb, Injector<SecurityRealm> injector, String realmName) {
            return sb.addDependency(ServiceUtil.createServiceName(realmName), SecurityRealm.class, injector);
        }

        public static Supplier<SecurityRealm> requires(ServiceBuilder<?> sb, String realmName) {
            return sb.requires(ServiceUtil.createServiceName(realmName));
        }
    }
}

