/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.password.interfaces.ClearPassword;

abstract class AbstractKeyManagerService
implements Service {
    private volatile char[] keystorePassword;
    private volatile char[] keyPassword;
    private final Consumer<AbstractKeyManagerService> keyManagerServiceConsumer;
    private final ExceptionSupplier<CredentialSource, Exception> keyCredentialSourceSupplier;
    private final ExceptionSupplier<CredentialSource, Exception> keystoreCredentialSourceSupplier;

    AbstractKeyManagerService(Consumer<AbstractKeyManagerService> keyManagerServiceConsumer, ExceptionSupplier<CredentialSource, Exception> keyCredentialSourceSupplier, ExceptionSupplier<CredentialSource, Exception> keystoreCredentialSourceSupplier, char[] keystorePassword, char[] keyPassword) {
        this.keyManagerServiceConsumer = keyManagerServiceConsumer;
        this.keyCredentialSourceSupplier = keyCredentialSourceSupplier;
        this.keystoreCredentialSourceSupplier = keystoreCredentialSourceSupplier;
        this.keystorePassword = keystorePassword;
        this.keyPassword = keyPassword;
    }

    public char[] getKeystorePassword() {
        return this.keystorePassword;
    }

    public void setKeystorePassword(char[] keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public char[] getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(char[] keyPassword) {
        this.keyPassword = keyPassword;
    }

    public void start(StartContext context) throws StartException {
        try {
            this.createKeyManagers(true);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw DomainManagementLogger.ROOT_LOGGER.unableToStart(e);
        }
        this.keyManagerServiceConsumer.accept(this);
    }

    public void stop(StopContext context) {
        this.keyManagerServiceConsumer.accept(null);
    }

    public KeyManager[] getKeyManagers() {
        try {
            return this.createKeyManagers(false);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract boolean isLazy();

    protected KeyManager[] createKeyManagers(boolean startup) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException {
        KeyStore keyStore = this.loadKeyStore(startup);
        if (keyStore == null && startup) {
            return null;
        }
        char[] keyPass = this.resolveKeyPassword();
        if (keyPass == null) {
            keyPass = this.resolveKeystorePassword();
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, keyPass);
        return keyManagerFactory.getKeyManagers();
    }

    protected abstract KeyStore loadKeyStore(boolean var1);

    protected char[] resolveKeyPassword() {
        return this.resolvePassword(this.keyCredentialSourceSupplier, this.keyPassword);
    }

    protected char[] resolveKeystorePassword() {
        return this.resolvePassword(this.keystoreCredentialSourceSupplier, this.keystorePassword);
    }

    private char[] resolvePassword(ExceptionSupplier<CredentialSource, Exception> sourceSupplier, char[] legacyPassword) {
        try {
            if (sourceSupplier == null) {
                return legacyPassword;
            }
            CredentialSource cs = (CredentialSource)sourceSupplier.get();
            if (cs == null) {
                return legacyPassword;
            }
            PasswordCredential credential = (PasswordCredential)cs.getCredential(PasswordCredential.class);
            if (credential == null) {
                return legacyPassword;
            }
            ClearPassword password = (ClearPassword)credential.getPassword(ClearPassword.class);
            if (password == null) {
                return legacyPassword;
            }
            return password.getPassword();
        }
        catch (Exception ex) {
            return legacyPassword;
        }
    }

    static final class ServiceUtil {
        private static final String SERVICE_SUFFIX = "key-manager";

        ServiceUtil() {
        }

        public static ServiceName createServiceName(ServiceName parentService) {
            return parentService.append(new String[]{SERVICE_SUFFIX});
        }

        public static Supplier<AbstractKeyManagerService> requires(ServiceBuilder<?> sb, ServiceName parentService) {
            return sb.requires(ServiceUtil.createServiceName(parentService));
        }
    }
}

