/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.domain.management.security.ManagementUtil;
import org.jboss.as.domain.management.security.UserResourceDefinition;
import org.jboss.dmr.ModelNode;

public class UserWriteAttributeHandler
extends AbstractWriteAttributeHandler<Void> {
    public UserWriteAttributeHandler() {
        super(new AttributeDefinition[]{UserResourceDefinition.PASSWORD, UserResourceDefinition.CREDENTIAL_REFERENCE});
    }

    protected void finishModelStage(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode oldValue, Resource resource) throws OperationFailedException {
        super.finishModelStage(context, operation, attributeName, newValue, oldValue, resource);
        if (attributeName.equals(UserResourceDefinition.CREDENTIAL_REFERENCE.getName())) {
            CredentialReference.handleCredentialReferenceUpdate((OperationContext)context, (ModelNode)resource.getModel().get(attributeName), (String)attributeName);
        }
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        ManagementUtil.updateUserDomainCallbackHandler(context, operation, false);
        if (attributeName.equals(UserResourceDefinition.CREDENTIAL_REFERENCE.getName())) {
            return CredentialReference.applyCredentialReferenceUpdateToRuntime((OperationContext)context, (ModelNode)operation, (ModelNode)resolvedValue, (ModelNode)currentValue, (String)attributeName);
        }
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        if (attributeName.equals(UserResourceDefinition.CREDENTIAL_REFERENCE.getName())) {
            CredentialReference.rollbackCredentialStoreUpdate((AttributeDefinition)UserResourceDefinition.CREDENTIAL_REFERENCE, (OperationContext)context, (ModelNode)valueToRevert);
        }
        ManagementUtil.updateUserDomainCallbackHandler(context, operation, true);
    }
}

