/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import org.jboss.as.core.security.RealmGroup;
import org.jboss.as.core.security.RealmUser;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.PropertiesFileLoader;
import org.jboss.as.domain.management.security.SubjectSupplemental;
import org.jboss.as.domain.management.security.SubjectSupplementalService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class PropertiesSubjectSupplemental
extends PropertiesFileLoader
implements Service<SubjectSupplementalService>,
SubjectSupplementalService,
SubjectSupplemental {
    private static final String SERVICE_SUFFIX = "properties_authorization";
    private static final String COMMA = ",";
    private final String realmName;

    public PropertiesSubjectSupplemental(String realmName, String path, String relativeTo) {
        super(path, relativeTo);
        this.realmName = realmName;
    }

    public SubjectSupplementalService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
    }

    @Override
    public SubjectSupplemental getSubjectSupplemental(Map<String, Object> sharedState) {
        return this;
    }

    @Override
    public void supplementSubject(Subject subject) throws IOException {
        Set<RealmUser> users = subject.getPrincipals(RealmUser.class);
        Set<Principal> principals = subject.getPrincipals();
        Properties properties = this.getProperties();
        for (RealmUser current : users) {
            principals.addAll(this.loadGroups(properties, current));
        }
    }

    private Set<RealmGroup> loadGroups(Properties properties, RealmUser user) {
        Set<RealmGroup> response;
        String groupString = properties.getProperty(user.getName(), "").trim();
        if (groupString.length() > 0) {
            String[] groups = groupString.split(COMMA);
            response = new HashSet<RealmGroup>(groups.length);
            for (String current : groups) {
                String cleaned = current.trim();
                if (cleaned.length() <= 0) continue;
                RealmGroup newGroup = new RealmGroup(this.realmName, cleaned);
                DomainManagementLogger.SECURITY_LOGGER.tracef("Adding group '%s' for user '%s'.", newGroup, user);
                response.add(newGroup);
            }
        } else {
            DomainManagementLogger.SECURITY_LOGGER.tracef("No roles found for user '%s' in properties file.", user);
            response = Collections.emptySet();
        }
        return response;
    }

    public static final class ServiceUtil {
        private ServiceUtil() {
        }

        public static ServiceName createServiceName(String realmName) {
            return SecurityRealm.ServiceUtil.createServiceName(realmName).append(new String[]{PropertiesSubjectSupplemental.SERVICE_SUFFIX});
        }
    }
}

