/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.core.security.ServerSecurityManager;
import org.jboss.as.domain.management.AuthMechanism;
import org.jboss.as.domain.management.CallbackHandlerFactory;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionManagerService;
import org.jboss.as.domain.management.security.AbstractKeyManagerService;
import org.jboss.as.domain.management.security.AbstractTrustManagerService;
import org.jboss.as.domain.management.security.AdvancedUserSearchResourceDefintion;
import org.jboss.as.domain.management.security.AuthenticationValidatingHandler;
import org.jboss.as.domain.management.security.AuthorizationValidatingHandler;
import org.jboss.as.domain.management.security.BaseLdapGroupSearchResource;
import org.jboss.as.domain.management.security.CallbackHandlerService;
import org.jboss.as.domain.management.security.ClientCertCallbackHandler;
import org.jboss.as.domain.management.security.FileKeyManagerService;
import org.jboss.as.domain.management.security.FileTrustManagerService;
import org.jboss.as.domain.management.security.GroupToPrincipalResourceDefinition;
import org.jboss.as.domain.management.security.JaasAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.JaasCallbackHandler;
import org.jboss.as.domain.management.security.KerberosAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.KerberosCallbackHandler;
import org.jboss.as.domain.management.security.KeystoreAttributes;
import org.jboss.as.domain.management.security.KeytabIdentityFactoryService;
import org.jboss.as.domain.management.security.KeytabResourceDefinition;
import org.jboss.as.domain.management.security.KeytabService;
import org.jboss.as.domain.management.security.LdapAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.LdapAuthorizationResourceDefinition;
import org.jboss.as.domain.management.security.LdapCacheResourceDefinition;
import org.jboss.as.domain.management.security.LdapCacheService;
import org.jboss.as.domain.management.security.LdapEntry;
import org.jboss.as.domain.management.security.LdapGroupSearcherFactory;
import org.jboss.as.domain.management.security.LdapSearcher;
import org.jboss.as.domain.management.security.LdapSearcherCache;
import org.jboss.as.domain.management.security.LdapSubjectSupplementalService;
import org.jboss.as.domain.management.security.LdapUserSearcherFactory;
import org.jboss.as.domain.management.security.LocalAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.LocalCallbackHandlerService;
import org.jboss.as.domain.management.security.ManagementUtil;
import org.jboss.as.domain.management.security.PlugInAuthenticationCallbackHandler;
import org.jboss.as.domain.management.security.PlugInAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.PlugInAuthorizationResourceDefinition;
import org.jboss.as.domain.management.security.PlugInLoaderService;
import org.jboss.as.domain.management.security.PlugInSubjectSupplemental;
import org.jboss.as.domain.management.security.PrincipalToGroupResourceDefinition;
import org.jboss.as.domain.management.security.PropertiesAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.PropertiesAuthorizationResourceDefinition;
import org.jboss.as.domain.management.security.PropertiesCallbackHandler;
import org.jboss.as.domain.management.security.PropertiesSubjectSupplemental;
import org.jboss.as.domain.management.security.PropertyResourceDefinition;
import org.jboss.as.domain.management.security.ProviderKeyManagerService;
import org.jboss.as.domain.management.security.ProviderTrustManagerService;
import org.jboss.as.domain.management.security.SSLContextService;
import org.jboss.as.domain.management.security.SSLServerIdentityResourceDefinition;
import org.jboss.as.domain.management.security.SecretIdentityService;
import org.jboss.as.domain.management.security.SecretServerIdentityResourceDefinition;
import org.jboss.as.domain.management.security.SecurityRealmResourceDefinition;
import org.jboss.as.domain.management.security.SecurityRealmService;
import org.jboss.as.domain.management.security.SubjectSupplementalService;
import org.jboss.as.domain.management.security.UserDomainCallbackHandler;
import org.jboss.as.domain.management.security.UserIsDnResourceDefintion;
import org.jboss.as.domain.management.security.UserLdapCallbackHandler;
import org.jboss.as.domain.management.security.UserSearchResourceDefintion;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedSetValue;
import org.jboss.msc.value.InjectedValue;

public class SecurityRealmAddHandler
implements OperationStepHandler {
    public static final SecurityRealmAddHandler INSTANCE = new SecurityRealmAddHandler();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode model = context.createResource(PathAddress.EMPTY_ADDRESS).getModel();
        SecurityRealmResourceDefinition.MAP_GROUPS_TO_ROLES.validateAndSet(operation, model);
        ModelNode validationOp = AuthenticationValidatingHandler.createOperation(operation);
        context.addStep(validationOp, (OperationStepHandler)AuthenticationValidatingHandler.INSTANCE, OperationContext.Stage.MODEL);
        validationOp = AuthorizationValidatingHandler.createOperation(operation);
        context.addStep(validationOp, (OperationStepHandler)AuthorizationValidatingHandler.INSTANCE, OperationContext.Stage.MODEL);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                context.addStep((OperationStepHandler)ServiceInstallStepHandler.INSTANCE, OperationContext.Stage.RUNTIME);
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    protected void installServices(OperationContext context, String realmName, ModelNode model) throws OperationFailedException {
        ModelNode plugIns = model.hasDefined("plug-in") ? model.get("plug-in") : null;
        ModelNode authentication = model.hasDefined("authentication") ? model.get("authentication") : null;
        ModelNode authorization = model.hasDefined("authorization") ? model.get("authorization") : null;
        ModelNode serverIdentities = model.hasDefined("server-identity") ? model.get("server-identity") : null;
        ServiceTarget serviceTarget = context.getServiceTarget();
        boolean mapGroupsToRoles = SecurityRealmResourceDefinition.MAP_GROUPS_TO_ROLES.resolveModelAttribute(context, model).asBoolean();
        SecurityRealmService securityRealmService = new SecurityRealmService(realmName, mapGroupsToRoles);
        ServiceName realmServiceName = SecurityRealm.ServiceUtil.createServiceName(realmName);
        ServiceBuilder realmBuilder = serviceTarget.addService(realmServiceName, (Service)securityRealmService);
        boolean shareLdapConnections = this.shareLdapConnection(context, authentication, authorization);
        ModelNode authTruststore = null;
        if (plugIns != null) {
            this.addPlugInLoaderService(realmName, plugIns, serviceTarget);
        }
        InjectedSetValue<CallbackHandlerService> injectorSet = securityRealmService.getCallbackHandlerService();
        if (authentication != null) {
            if (authentication.hasDefined("truststore")) {
                authTruststore = authentication.require("truststore");
                this.addClientCertService(realmName, serviceTarget, realmBuilder, (Injector<CallbackHandlerService>)injectorSet.injector());
            }
            if (authentication.hasDefined("local")) {
                this.addLocalService(context, authentication.require("local"), realmName, serviceTarget, realmBuilder, (Injector<CallbackHandlerService>)injectorSet.injector());
            }
            if (authentication.hasDefined("kerberos")) {
                this.addKerberosService(context, authentication.require("kerberos"), realmName, serviceTarget, realmBuilder, (Injector<CallbackHandlerService>)injectorSet.injector());
            }
            if (authentication.hasDefined("jaas")) {
                this.addJaasService(context, authentication.require("jaas"), realmName, serviceTarget, context.isNormalServer(), realmBuilder, (Injector<CallbackHandlerService>)injectorSet.injector());
            } else if (authentication.hasDefined("ldap")) {
                this.addLdapService(context, authentication.require("ldap"), realmName, serviceTarget, realmBuilder, (Injector<CallbackHandlerService>)injectorSet.injector(), shareLdapConnections);
            } else if (authentication.hasDefined("plug-in")) {
                this.addPlugInAuthenticationService(context, authentication.require("plug-in"), realmName, securityRealmService, serviceTarget, realmBuilder, (Injector<CallbackHandlerService>)injectorSet.injector());
            } else if (authentication.hasDefined("properties")) {
                this.addPropertiesAuthenticationService(context, authentication.require("properties"), realmName, serviceTarget, realmBuilder, (Injector<CallbackHandlerService>)injectorSet.injector());
            } else if (authentication.hasDefined("users")) {
                this.addUsersService(context, authentication.require("users"), realmName, serviceTarget, realmBuilder, (Injector<CallbackHandlerService>)injectorSet.injector());
            }
        }
        if (authorization != null) {
            if (authorization.hasDefined("properties")) {
                this.addPropertiesAuthorizationService(context, authorization.require("properties"), realmName, serviceTarget, realmBuilder, securityRealmService.getSubjectSupplementalInjector());
            } else if (authorization.hasDefined("plug-in")) {
                this.addPlugInAuthorizationService(context, authorization.require("plug-in"), realmName, serviceTarget, realmBuilder, securityRealmService.getSubjectSupplementalInjector());
            } else if (authorization.hasDefined("ldap")) {
                this.addLdapAuthorizationService(context, authorization.require("ldap"), realmName, serviceTarget, realmBuilder, securityRealmService.getSubjectSupplementalInjector(), shareLdapConnections);
            }
        }
        ModelNode ssl = null;
        if (serverIdentities != null) {
            if (serverIdentities.hasDefined("ssl")) {
                ssl = serverIdentities.require("ssl");
            }
            if (serverIdentities.hasDefined("secret")) {
                this.addSecretService(context, serverIdentities.require("secret"), realmName, serviceTarget, (ServiceBuilder<?>)realmBuilder, (Injector<CallbackHandlerFactory>)securityRealmService.getSecretCallbackFactory());
            }
            if (serverIdentities.hasDefined("kerberos")) {
                this.addKerberosIdentityServices(context, serverIdentities.require("kerberos"), realmName, serviceTarget, (ServiceBuilder<?>)realmBuilder, (Injector<KeytabIdentityFactoryService>)securityRealmService.getKeytabIdentityFactoryInjector());
            }
        }
        if (ssl != null || authTruststore != null) {
            this.addSSLServices(context, ssl, authTruststore, realmName, serviceTarget, realmBuilder, securityRealmService.getSSLContextInjector());
        }
        realmBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        realmBuilder.install();
    }

    private boolean shareLdapConnection(OperationContext context, ModelNode authentication, ModelNode authorization) throws OperationFailedException {
        if (authentication == null || authorization == null || !authentication.hasDefined("ldap") || !authorization.hasDefined("ldap")) {
            return false;
        }
        String authConnectionManager = LdapAuthenticationResourceDefinition.CONNECTION.resolveModelAttribute(context, authentication.require("ldap")).asString();
        String authzConnectionManager = LdapAuthorizationResourceDefinition.CONNECTION.resolveModelAttribute(context, authorization.require("ldap")).asString();
        return authConnectionManager.equals(authzConnectionManager);
    }

    private ServiceName addPlugInLoaderService(String realmName, ModelNode plugInModel, ServiceTarget serviceTarget) {
        ServiceName plugInLoaderName = PlugInLoaderService.ServiceUtil.createServiceName(realmName);
        List plugIns = plugInModel.asPropertyList();
        ArrayList<String> knownNames = new ArrayList<String>(plugIns.size());
        for (Property current : plugIns) {
            knownNames.add(current.getName());
        }
        PlugInLoaderService loaderService = new PlugInLoaderService(Collections.unmodifiableList(knownNames));
        serviceTarget.addService(plugInLoaderName, (Service)loaderService).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        return plugInLoaderName;
    }

    private void addClientCertService(String realmName, ServiceTarget serviceTarget, ServiceBuilder<?> realmBuilder, Injector<CallbackHandlerService> injector) {
        ServiceName clientCertServiceName = ClientCertCallbackHandler.ServiceUtil.createServiceName(realmName);
        ClientCertCallbackHandler clientCertCallbackHandler = new ClientCertCallbackHandler();
        serviceTarget.addService(clientCertServiceName, (Service)clientCertCallbackHandler).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        CallbackHandlerService.ServiceUtil.addDependency(realmBuilder, injector, clientCertServiceName, false);
    }

    private void addKerberosService(OperationContext context, ModelNode kerberos, String realmName, ServiceTarget serviceTarget, ServiceBuilder<?> realmBuilder, Injector<CallbackHandlerService> injector) throws OperationFailedException {
        ServiceName kerberosServiceName = KerberosCallbackHandler.ServiceUtil.createServiceName(realmName);
        boolean removeRealm = KerberosAuthenticationResourceDefinition.REMOVE_REALM.resolveModelAttribute(context, kerberos).asBoolean();
        KerberosCallbackHandler kerberosCallbackHandler = new KerberosCallbackHandler(removeRealm);
        ServiceBuilder ccBuilder = serviceTarget.addService(kerberosServiceName, (Service)kerberosCallbackHandler);
        ccBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        CallbackHandlerService.ServiceUtil.addDependency(realmBuilder, injector, kerberosServiceName, false);
    }

    private void addJaasService(OperationContext context, ModelNode jaas, String realmName, ServiceTarget serviceTarget, boolean injectServerManager, ServiceBuilder<?> realmBuilder, Injector<CallbackHandlerService> injector) throws OperationFailedException {
        ServiceName jaasServiceName = JaasCallbackHandler.ServiceUtil.createServiceName(realmName);
        String name = JaasAuthenticationResourceDefinition.NAME.resolveModelAttribute(context, jaas).asString();
        boolean assignGroups = JaasAuthenticationResourceDefinition.ASSIGN_GROUPS.resolveModelAttribute(context, jaas).asBoolean();
        JaasCallbackHandler jaasCallbackHandler = new JaasCallbackHandler(realmName, name, assignGroups);
        ServiceBuilder jaasBuilder = serviceTarget.addService(jaasServiceName, (Service)jaasCallbackHandler);
        if (injectServerManager) {
            jaasBuilder.addDependency(ServiceName.JBOSS.append(new String[]{"security", "simple-security-manager"}), ServerSecurityManager.class, jaasCallbackHandler.getSecurityManagerValue());
        }
        jaasBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        CallbackHandlerService.ServiceUtil.addDependency(realmBuilder, injector, jaasServiceName, false);
    }

    private <R, K> LdapCacheService<R, K> createCacheService(OperationContext context, LdapSearcher<R, K> searcher, ModelNode cache) throws OperationFailedException {
        if (cache != null && cache.isDefined()) {
            ModelNode cacheDefinition = null;
            boolean byAccessTime = false;
            if (cache.hasDefined("by-access-time")) {
                cacheDefinition = cache.require("by-access-time");
                byAccessTime = true;
            } else if (cache.hasDefined("by-search-time")) {
                cacheDefinition = cache.require("by-search-time");
            }
            if (cacheDefinition != null) {
                int evictionTime = LdapCacheResourceDefinition.EVICTION_TIME.resolveModelAttribute(context, cacheDefinition).asInt();
                boolean cacheFailures = LdapCacheResourceDefinition.CACHE_FAILURES.resolveModelAttribute(context, cacheDefinition).asBoolean();
                int maxSize = LdapCacheResourceDefinition.MAX_CACHE_SIZE.resolveModelAttribute(context, cacheDefinition).asInt();
                return byAccessTime ? LdapCacheService.createByAccessCacheService(searcher, evictionTime, cacheFailures, maxSize) : LdapCacheService.createBySearchCacheService(searcher, evictionTime, cacheFailures, maxSize);
            }
        }
        return LdapCacheService.createNoCacheService(searcher);
    }

    private void addLdapService(OperationContext context, ModelNode ldap, String realmName, ServiceTarget serviceTarget, ServiceBuilder<?> realmBuilder, Injector<CallbackHandlerService> injector, boolean shareConnection) throws OperationFailedException {
        ServiceName ldapServiceName = UserLdapCallbackHandler.ServiceUtil.createServiceName(realmName);
        String baseDn = LdapAuthenticationResourceDefinition.BASE_DN.resolveModelAttribute(context, ldap).asString();
        ModelNode node = LdapAuthenticationResourceDefinition.USERNAME_FILTER.resolveModelAttribute(context, ldap);
        String usernameAttribute = node.isDefined() ? node.asString() : null;
        node = LdapAuthenticationResourceDefinition.ADVANCED_FILTER.resolveModelAttribute(context, ldap);
        String advancedFilter = node.isDefined() ? node.asString() : null;
        node = LdapAuthenticationResourceDefinition.USERNAME_LOAD.resolveModelAttribute(context, ldap);
        String usernameLoad = node.isDefined() ? node.asString() : null;
        boolean recursive = LdapAuthenticationResourceDefinition.RECURSIVE.resolveModelAttribute(context, ldap).asBoolean();
        boolean allowEmptyPasswords = LdapAuthenticationResourceDefinition.ALLOW_EMPTY_PASSWORDS.resolveModelAttribute(context, ldap).asBoolean();
        String userDn = LdapAuthenticationResourceDefinition.USER_DN.resolveModelAttribute(context, ldap).asString();
        UserLdapCallbackHandler ldapCallbackHandler = new UserLdapCallbackHandler(allowEmptyPasswords, shareConnection);
        LdapSearcher<LdapEntry, String> userSearcher = usernameAttribute != null ? LdapUserSearcherFactory.createForUsernameFilter(baseDn, recursive, userDn, usernameAttribute, usernameLoad) : LdapUserSearcherFactory.createForAdvancedFilter(baseDn, recursive, userDn, advancedFilter, usernameLoad);
        LdapCacheService<LdapEntry, String> cacheService = this.createCacheService(context, userSearcher, ldap.get("cache"));
        ServiceName userSearcherCacheName = LdapSearcherCache.ServiceUtil.createServiceName(true, true, realmName);
        serviceTarget.addService(userSearcherCacheName, cacheService).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        ServiceBuilder ldapBuilder = serviceTarget.addService(ldapServiceName, (Service)ldapCallbackHandler);
        String connectionManager = LdapAuthenticationResourceDefinition.CONNECTION.resolveModelAttribute(context, ldap).asString();
        LdapConnectionManagerService.ServiceUtil.addDependency(ldapBuilder, ldapCallbackHandler.getConnectionManagerInjector(), connectionManager, false);
        LdapSearcherCache.ServiceUtil.addDependency(ldapBuilder, LdapSearcherCache.class, ldapCallbackHandler.getLdapUserSearcherInjector(), true, true, realmName);
        ldapBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        CallbackHandlerService.ServiceUtil.addDependency(realmBuilder, injector, ldapServiceName, false);
    }

    private void addLocalService(OperationContext context, ModelNode local, String realmName, ServiceTarget serviceTarget, ServiceBuilder<?> realmBuilder, Injector<CallbackHandlerService> injector) throws OperationFailedException {
        ServiceName localServiceName = LocalCallbackHandlerService.ServiceUtil.createServiceName(realmName);
        ModelNode node = LocalAuthenticationResourceDefinition.DEFAULT_USER.resolveModelAttribute(context, local);
        String defaultUser = node.isDefined() ? node.asString() : null;
        node = LocalAuthenticationResourceDefinition.ALLOWED_USERS.resolveModelAttribute(context, local);
        String allowedUsers = node.isDefined() ? node.asString() : null;
        node = LocalAuthenticationResourceDefinition.SKIP_GROUP_LOADING.resolveModelAttribute(context, local);
        boolean skipGroupLoading = node.asBoolean();
        LocalCallbackHandlerService localCallbackHandler = new LocalCallbackHandlerService(defaultUser, allowedUsers, skipGroupLoading);
        serviceTarget.addService(localServiceName, (Service)localCallbackHandler).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        CallbackHandlerService.ServiceUtil.addDependency(realmBuilder, injector, localServiceName, false);
    }

    private void addPlugInAuthenticationService(OperationContext context, ModelNode model, String realmName, SecurityRealmService registry, ServiceTarget serviceTarget, ServiceBuilder<?> realmBuilder, Injector<CallbackHandlerService> injector) throws OperationFailedException {
        ServiceName plugInServiceName = PlugInAuthenticationCallbackHandler.ServiceUtil.createServiceName(realmName);
        String pluginName = PlugInAuthorizationResourceDefinition.NAME.resolveModelAttribute(context, model).asString();
        Map<String, String> properties = SecurityRealmAddHandler.resolveProperties(context, model);
        String mechanismName = PlugInAuthenticationResourceDefinition.MECHANISM.resolveModelAttribute(context, model).asString();
        AuthMechanism mechanism = AuthMechanism.valueOf(mechanismName);
        PlugInAuthenticationCallbackHandler plugInService = new PlugInAuthenticationCallbackHandler(registry.getName(), pluginName, properties, mechanism);
        ServiceBuilder plugInBuilder = serviceTarget.addService(plugInServiceName, (Service)plugInService);
        PlugInLoaderService.ServiceUtil.addDependency(plugInBuilder, (InjectedValue<PlugInLoaderService>)plugInService.getPlugInLoaderServiceValue(), realmName, false);
        plugInBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        CallbackHandlerService.ServiceUtil.addDependency(realmBuilder, injector, plugInServiceName, false);
    }

    private void addPropertiesAuthenticationService(OperationContext context, ModelNode properties, String realmName, ServiceTarget serviceTarget, ServiceBuilder<?> realmBuilder, Injector<CallbackHandlerService> injector) throws OperationFailedException {
        ServiceName propsServiceName = PropertiesCallbackHandler.ServiceUtil.createServiceName(realmName);
        String path = PropertiesAuthenticationResourceDefinition.PATH.resolveModelAttribute(context, properties).asString();
        ModelNode relativeToNode = PropertiesAuthenticationResourceDefinition.RELATIVE_TO.resolveModelAttribute(context, properties);
        boolean plainText = PropertiesAuthenticationResourceDefinition.PLAIN_TEXT.resolveModelAttribute(context, properties).asBoolean();
        String relativeTo = relativeToNode.isDefined() ? relativeToNode.asString() : null;
        PropertiesCallbackHandler propsCallbackHandler = new PropertiesCallbackHandler(realmName, path, relativeTo, plainText);
        ServiceBuilder propsBuilder = serviceTarget.addService(propsServiceName, (Service)propsCallbackHandler);
        if (relativeTo != null) {
            propsBuilder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, propsCallbackHandler.getPathManagerInjectorInjector());
            propsBuilder.addDependency(SecurityRealmAddHandler.pathName(relativeTo));
        }
        propsBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        CallbackHandlerService.ServiceUtil.addDependency(realmBuilder, injector, propsServiceName, false);
    }

    private void addPropertiesAuthorizationService(OperationContext context, ModelNode properties, String realmName, ServiceTarget serviceTarget, ServiceBuilder<?> realmBuilder, InjectedValue<SubjectSupplementalService> injector) throws OperationFailedException {
        ServiceName propsServiceName = PropertiesSubjectSupplemental.ServiceUtil.createServiceName(realmName);
        String path = PropertiesAuthorizationResourceDefinition.PATH.resolveModelAttribute(context, properties).asString();
        ModelNode relativeToNode = PropertiesAuthorizationResourceDefinition.RELATIVE_TO.resolveModelAttribute(context, properties);
        String relativeTo = relativeToNode.isDefined() ? relativeToNode.asString() : null;
        PropertiesSubjectSupplemental propsSubjectSupplemental = new PropertiesSubjectSupplemental(realmName, path, relativeTo);
        ServiceBuilder propsBuilder = serviceTarget.addService(propsServiceName, (Service)propsSubjectSupplemental);
        if (relativeTo != null) {
            propsBuilder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, propsSubjectSupplemental.getPathManagerInjectorInjector());
            propsBuilder.addDependency(SecurityRealmAddHandler.pathName(relativeTo));
        }
        propsBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        SubjectSupplementalService.ServiceUtil.addDependency(realmBuilder, injector, propsServiceName, false);
    }

    private void addPlugInAuthorizationService(OperationContext context, ModelNode model, String realmName, ServiceTarget serviceTarget, ServiceBuilder<?> realmBuilder, InjectedValue<SubjectSupplementalService> injector) throws OperationFailedException {
        ServiceName plugInServiceName = PlugInSubjectSupplemental.ServiceUtil.createServiceName(realmName);
        String pluginName = PlugInAuthorizationResourceDefinition.NAME.resolveModelAttribute(context, model).asString();
        Map<String, String> properties = SecurityRealmAddHandler.resolveProperties(context, model);
        PlugInSubjectSupplemental plugInSubjectSupplemental = new PlugInSubjectSupplemental(realmName, pluginName, properties);
        ServiceBuilder plugInBuilder = serviceTarget.addService(plugInServiceName, (Service)plugInSubjectSupplemental);
        PlugInLoaderService.ServiceUtil.addDependency(plugInBuilder, (InjectedValue<PlugInLoaderService>)plugInSubjectSupplemental.getPlugInLoaderServiceValue(), realmName, false);
        plugInBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        SubjectSupplementalService.ServiceUtil.addDependency(realmBuilder, injector, plugInServiceName, false);
    }

    private void addLdapAuthorizationService(OperationContext context, ModelNode ldap, String realmName, ServiceTarget serviceTarget, ServiceBuilder<?> realmBuilder, InjectedValue<SubjectSupplementalService> injector, boolean shareConnection) throws OperationFailedException {
        LdapSearcher<LdapEntry[], LdapEntry> groupSearcher;
        ServiceName ldapName = LdapSubjectSupplementalService.ServiceUtil.createServiceName(realmName);
        LdapSearcher<LdapEntry, String> userSearcher = null;
        boolean forceUserDnSearch = false;
        ModelNode userCache = null;
        if (ldap.hasDefined("username-to-dn")) {
            String userDnAttribute;
            boolean recursive;
            String baseDn;
            ModelNode usernameToDn = ldap.require("username-to-dn");
            if (usernameToDn.hasDefined("username-is-dn")) {
                ModelNode usernameIsDn = usernameToDn.require("username-is-dn");
                userCache = usernameIsDn.get("cache");
                forceUserDnSearch = UserIsDnResourceDefintion.FORCE.resolveModelAttribute(context, usernameIsDn).asBoolean();
                userSearcher = LdapUserSearcherFactory.createForUsernameIsDn();
            } else if (usernameToDn.hasDefined("username-filter")) {
                ModelNode usernameFilter = usernameToDn.require("username-filter");
                userCache = usernameFilter.get("cache");
                forceUserDnSearch = UserSearchResourceDefintion.FORCE.resolveModelAttribute(context, usernameFilter).asBoolean();
                baseDn = UserSearchResourceDefintion.BASE_DN.resolveModelAttribute(context, usernameFilter).asString();
                recursive = UserSearchResourceDefintion.RECURSIVE.resolveModelAttribute(context, usernameFilter).asBoolean();
                userDnAttribute = UserSearchResourceDefintion.USER_DN_ATTRIBUTE.resolveModelAttribute(context, usernameFilter).asString();
                String usernameAttribute = UserSearchResourceDefintion.ATTRIBUTE.resolveModelAttribute(context, usernameFilter).asString();
                userSearcher = LdapUserSearcherFactory.createForUsernameFilter(baseDn, recursive, userDnAttribute, usernameAttribute, null);
            } else if (usernameToDn.hasDefined("advanced-filter")) {
                ModelNode advancedFilter = usernameToDn.require("advanced-filter");
                userCache = advancedFilter.get("cache");
                forceUserDnSearch = AdvancedUserSearchResourceDefintion.FORCE.resolveModelAttribute(context, advancedFilter).asBoolean();
                baseDn = AdvancedUserSearchResourceDefintion.BASE_DN.resolveModelAttribute(context, advancedFilter).asString();
                recursive = AdvancedUserSearchResourceDefintion.RECURSIVE.resolveModelAttribute(context, advancedFilter).asBoolean();
                userDnAttribute = AdvancedUserSearchResourceDefintion.USER_DN_ATTRIBUTE.resolveModelAttribute(context, advancedFilter).asString();
                String filter = AdvancedUserSearchResourceDefintion.FILTER.resolveModelAttribute(context, advancedFilter).asString();
                userSearcher = LdapUserSearcherFactory.createForAdvancedFilter(baseDn, recursive, userDnAttribute, filter, null);
            }
        }
        if (userSearcher != null) {
            LdapCacheService userSearcherCache = this.createCacheService(context, userSearcher, userCache);
            ServiceName userSearcherCacheName = LdapSearcherCache.ServiceUtil.createServiceName(false, true, realmName);
            serviceTarget.addService(userSearcherCacheName, userSearcherCache).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        }
        ModelNode groupSearch = ldap.require("group-search");
        boolean iterative = false;
        BaseLdapGroupSearchResource.GroupName groupName = BaseLdapGroupSearchResource.GroupName.DISTINGUISHED_NAME;
        ModelNode groupCache = null;
        if (groupSearch.hasDefined("group-to-principal")) {
            ModelNode groupToPrincipal = groupSearch.require("group-to-principal");
            groupCache = groupToPrincipal.get("cache");
            String baseDn = GroupToPrincipalResourceDefinition.BASE_DN.resolveModelAttribute(context, groupToPrincipal).asString();
            String groupDnAttribute = GroupToPrincipalResourceDefinition.GROUP_DN_ATTRIBUTE.resolveModelAttribute(context, groupToPrincipal).asString();
            groupName = BaseLdapGroupSearchResource.GroupName.valueOf(GroupToPrincipalResourceDefinition.GROUP_NAME.resolveModelAttribute(context, groupToPrincipal).asString());
            String groupNameAttribute = GroupToPrincipalResourceDefinition.GROUP_NAME_ATTRIBUTE.resolveModelAttribute(context, groupToPrincipal).asString();
            iterative = GroupToPrincipalResourceDefinition.ITERATIVE.resolveModelAttribute(context, groupToPrincipal).asBoolean();
            String principalAttribute = GroupToPrincipalResourceDefinition.PRINCIPAL_ATTRIBUTE.resolveModelAttribute(context, groupToPrincipal).asString();
            boolean recursive = GroupToPrincipalResourceDefinition.RECURSIVE.resolveModelAttribute(context, groupToPrincipal).asBoolean();
            BaseLdapGroupSearchResource.GroupName searchBy = BaseLdapGroupSearchResource.GroupName.valueOf(GroupToPrincipalResourceDefinition.SEARCH_BY.resolveModelAttribute(context, groupToPrincipal).asString());
            boolean preferOriginalConnection = GroupToPrincipalResourceDefinition.PREFER_ORIGINAL_CONNECTION.resolveModelAttribute(context, groupToPrincipal).asBoolean();
            groupSearcher = LdapGroupSearcherFactory.createForGroupToPrincipal(baseDn, groupDnAttribute, groupNameAttribute, principalAttribute, recursive, searchBy, preferOriginalConnection);
        } else {
            ModelNode principalToGroup = groupSearch.require("principal-to-group");
            groupCache = principalToGroup.get("cache");
            String groupAttribute = PrincipalToGroupResourceDefinition.GROUP_ATTRIBUTE.resolveModelAttribute(context, principalToGroup).asString();
            boolean preferOriginalConnection = PrincipalToGroupResourceDefinition.PREFER_ORIGINAL_CONNECTION.resolveModelAttribute(context, principalToGroup).asBoolean();
            String groupDnAttribute = PrincipalToGroupResourceDefinition.GROUP_DN_ATTRIBUTE.resolveModelAttribute(context, principalToGroup).asString();
            groupName = BaseLdapGroupSearchResource.GroupName.valueOf(PrincipalToGroupResourceDefinition.GROUP_NAME.resolveModelAttribute(context, principalToGroup).asString());
            String groupNameAttribute = PrincipalToGroupResourceDefinition.GROUP_NAME_ATTRIBUTE.resolveModelAttribute(context, principalToGroup).asString();
            iterative = PrincipalToGroupResourceDefinition.ITERATIVE.resolveModelAttribute(context, principalToGroup).asBoolean();
            boolean skipMissingGroups = PrincipalToGroupResourceDefinition.SKIP_MISSING_GROUPS.resolveModelAttribute(context, principalToGroup).asBoolean();
            groupSearcher = LdapGroupSearcherFactory.createForPrincipalToGroup(groupAttribute, groupNameAttribute, preferOriginalConnection, skipMissingGroups, BaseLdapGroupSearchResource.GroupName.SIMPLE == groupName);
        }
        LdapCacheService<LdapEntry[], LdapEntry> groupCacheService = this.createCacheService(context, groupSearcher, groupCache);
        ServiceName groupCacheServiceName = LdapSearcherCache.ServiceUtil.createServiceName(false, false, realmName);
        serviceTarget.addService(groupCacheServiceName, groupCacheService).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        String connectionName = LdapAuthorizationResourceDefinition.CONNECTION.resolveModelAttribute(context, ldap).asString();
        LdapSubjectSupplementalService service = new LdapSubjectSupplementalService(realmName, shareConnection, forceUserDnSearch, iterative, groupName);
        ServiceBuilder ldapBuilder = serviceTarget.addService(ldapName, (Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND);
        LdapConnectionManagerService.ServiceUtil.addDependency(ldapBuilder, service.getConnectionManagerInjector(), connectionName, false);
        if (userSearcher != null) {
            LdapSearcherCache.ServiceUtil.addDependency(ldapBuilder, LdapSearcherCache.class, service.getLdapUserSearcherInjector(), false, true, realmName);
        }
        LdapSearcherCache.ServiceUtil.addDependency(ldapBuilder, LdapSearcherCache.class, service.getLdapGroupSearcherInjector(), false, false, realmName);
        ldapBuilder.install();
        SubjectSupplementalService.ServiceUtil.addDependency(realmBuilder, injector, ldapName, false);
    }

    private void addSSLServices(OperationContext context, ModelNode ssl, ModelNode trustStore, String realmName, ServiceTarget serviceTarget, ServiceBuilder<?> realmBuilder, InjectedValue<SSLContext> injector) throws OperationFailedException {
        ssl = ssl == null ? new ModelNode() : ssl;
        ServiceName keyManagerServiceName = null;
        String provider = KeystoreAttributes.KEYSTORE_PROVIDER.resolveModelAttribute(context, ssl).asString();
        if (ssl.hasDefined("keystore-path") || !"JKS".equalsIgnoreCase(provider)) {
            keyManagerServiceName = AbstractKeyManagerService.ServiceUtil.createServiceName(SecurityRealm.ServiceUtil.createServiceName(realmName));
            this.addKeyManagerService(context, ssl, keyManagerServiceName, serviceTarget);
        }
        ServiceName trustManagerServiceName = null;
        if (trustStore != null) {
            trustManagerServiceName = AbstractTrustManagerService.ServiceUtil.createServiceName(SecurityRealm.ServiceUtil.createServiceName(realmName));
            this.addTrustManagerService(context, trustStore, trustManagerServiceName, serviceTarget);
        }
        String protocol = SSLServerIdentityResourceDefinition.PROTOCOL.resolveModelAttribute(context, ssl).asString();
        HashSet<String> enabledCipherSuites = new HashSet<String>();
        ModelNode suitesNode = SSLServerIdentityResourceDefinition.ENABLED_CIPHER_SUITES.resolveModelAttribute(context, ssl);
        if (suitesNode.isDefined()) {
            List list = suitesNode.asList();
            for (ModelNode current : list) {
                enabledCipherSuites.add(current.asString());
            }
        }
        HashSet<String> enabledProtocols = new HashSet<String>();
        ModelNode protocolsNode = SSLServerIdentityResourceDefinition.ENABLED_PROTOCOLS.resolveModelAttribute(context, ssl);
        if (protocolsNode.isDefined()) {
            List list = protocolsNode.asList();
            for (ModelNode current : list) {
                enabledProtocols.add(current.asString());
            }
        }
        ServiceName fullServiceName = SSLContextService.ServiceUtil.createServiceName(SecurityRealm.ServiceUtil.createServiceName(realmName), false);
        ServiceName trustOnlyServiceName = SSLContextService.ServiceUtil.createServiceName(SecurityRealm.ServiceUtil.createServiceName(realmName), true);
        if (keyManagerServiceName != null) {
            SSLContextService fullSSLContextService = new SSLContextService(protocol, enabledCipherSuites, enabledProtocols);
            ServiceBuilder fullBuilder = serviceTarget.addService(fullServiceName, (Service)fullSSLContextService);
            AbstractKeyManagerService.ServiceUtil.addDependency(fullBuilder, fullSSLContextService.getKeyManagerInjector(), SecurityRealm.ServiceUtil.createServiceName(realmName));
            if (trustManagerServiceName != null) {
                AbstractTrustManagerService.ServiceUtil.addDependency(fullBuilder, fullSSLContextService.getTrustManagerInjector(), SecurityRealm.ServiceUtil.createServiceName(realmName));
            }
            fullBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        }
        SSLContextService trustOnlySSLContextService = new SSLContextService(protocol, enabledCipherSuites, enabledProtocols);
        ServiceBuilder trustBuilder = serviceTarget.addService(trustOnlyServiceName, (Service)trustOnlySSLContextService);
        if (keyManagerServiceName == null) {
            trustBuilder.addAliases(new ServiceName[]{fullServiceName});
        }
        if (trustManagerServiceName != null) {
            AbstractTrustManagerService.ServiceUtil.addDependency(trustBuilder, trustOnlySSLContextService.getTrustManagerInjector(), SecurityRealm.ServiceUtil.createServiceName(realmName));
        }
        trustBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        SSLContextService.ServiceUtil.addDependency(realmBuilder, injector, SecurityRealm.ServiceUtil.createServiceName(realmName), false);
    }

    private void addKeyManagerService(OperationContext context, ModelNode ssl, ServiceName serviceName, ServiceTarget serviceTarget) throws OperationFailedException {
        ServiceBuilder serviceBuilder;
        ModelNode pathNode;
        char[] keystorePassword = KeystoreAttributes.KEYSTORE_PASSWORD.resolveModelAttribute(context, ssl).asString().toCharArray();
        String provider = KeystoreAttributes.KEYSTORE_PROVIDER.resolveModelAttribute(context, ssl).asString();
        String autoGenerateCertHostName = null;
        ModelNode autoGenerateCertHostNode = KeystoreAttributes.GENERATE_SELF_SIGNED_CERTIFICATE_HOST.resolveModelAttribute(context, ssl);
        if (autoGenerateCertHostNode.isDefined()) {
            autoGenerateCertHostName = autoGenerateCertHostNode.asString();
        }
        if (!(pathNode = KeystoreAttributes.KEYSTORE_PATH.resolveModelAttribute(context, ssl)).isDefined()) {
            ProviderKeyManagerService keyManagerService = new ProviderKeyManagerService(provider, keystorePassword);
            serviceBuilder = serviceTarget.addService(serviceName, (Service)keyManagerService);
        } else {
            String path = pathNode.asString();
            ModelNode pwordNode = KeystoreAttributes.KEY_PASSWORD.resolveModelAttribute(context, ssl);
            char[] keyPassword = pwordNode.isDefined() ? pwordNode.asString().toCharArray() : null;
            ModelNode relativeToNode = KeystoreAttributes.KEYSTORE_RELATIVE_TO.resolveModelAttribute(context, ssl);
            String relativeTo = relativeToNode.isDefined() ? relativeToNode.asString() : null;
            ModelNode aliasNode = KeystoreAttributes.ALIAS.resolveModelAttribute(context, ssl);
            String alias = aliasNode.isDefined() ? aliasNode.asString() : null;
            FileKeyManagerService keyManagerService = new FileKeyManagerService(provider, path, relativeTo, keystorePassword, keyPassword, alias, autoGenerateCertHostName);
            serviceBuilder = serviceTarget.addService(serviceName, (Service)keyManagerService);
            if (relativeTo != null) {
                serviceBuilder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, keyManagerService.getPathManagerInjector());
                serviceBuilder.addDependency(SecurityRealmAddHandler.pathName(relativeTo));
            }
        }
        serviceBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
    }

    private void addTrustManagerService(OperationContext context, ModelNode ssl, ServiceName serviceName, ServiceTarget serviceTarget) throws OperationFailedException {
        ServiceBuilder serviceBuilder;
        char[] keystorePassword = KeystoreAttributes.KEYSTORE_PASSWORD.resolveModelAttribute(context, ssl).asString().toCharArray();
        String provider = KeystoreAttributes.KEYSTORE_PROVIDER.resolveModelAttribute(context, ssl).asString();
        if (!"JKS".equalsIgnoreCase(provider)) {
            ProviderTrustManagerService trustManagerService = new ProviderTrustManagerService(provider, keystorePassword);
            serviceBuilder = serviceTarget.addService(serviceName, (Service)trustManagerService);
        } else {
            String path = KeystoreAttributes.KEYSTORE_PATH.resolveModelAttribute(context, ssl).asString();
            ModelNode relativeToNode = KeystoreAttributes.KEYSTORE_RELATIVE_TO.resolveModelAttribute(context, ssl);
            String relativeTo = relativeToNode.isDefined() ? relativeToNode.asString() : null;
            FileTrustManagerService trustManagerService = new FileTrustManagerService(provider, path, relativeTo, keystorePassword);
            serviceBuilder = serviceTarget.addService(serviceName, (Service)trustManagerService);
            if (relativeTo != null) {
                serviceBuilder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, trustManagerService.getPathManagerInjector());
                serviceBuilder.addDependency(SecurityRealmAddHandler.pathName(relativeTo));
            }
        }
        serviceBuilder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
    }

    private void addSecretService(OperationContext context, ModelNode secret, String realmName, ServiceTarget serviceTarget, ServiceBuilder<?> realmBuilder, Injector<CallbackHandlerFactory> injector) throws OperationFailedException {
        ServiceName secretServiceName = SecretIdentityService.ServiceUtil.createServiceName(realmName);
        ModelNode resolvedValueNode = SecretServerIdentityResourceDefinition.VALUE.resolveModelAttribute(context, secret);
        boolean base64 = secret.get(SecretServerIdentityResourceDefinition.VALUE.getName()).getType() != ModelType.EXPRESSION;
        SecretIdentityService sis = new SecretIdentityService(resolvedValueNode.asString(), base64);
        serviceTarget.addService(secretServiceName, (Service)sis).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        CallbackHandlerFactory.ServiceUtil.addDependency(realmBuilder, injector, secretServiceName, false);
    }

    private void addKerberosIdentityServices(OperationContext context, ModelNode kerberos, String realmName, ServiceTarget serviceTarget, ServiceBuilder<?> realmBuilder, Injector<KeytabIdentityFactoryService> injector) throws OperationFailedException {
        ServiceName keyIdentityName = KeytabIdentityFactoryService.ServiceUtil.createServiceName(realmName);
        KeytabIdentityFactoryService kifs = new KeytabIdentityFactoryService();
        ServiceBuilder kifsBuilder = serviceTarget.addService(keyIdentityName, (Service)kifs).setInitialMode(ServiceController.Mode.ON_DEMAND);
        if (kerberos.hasDefined("keytab")) {
            List keytabList = kerberos.get("keytab").asPropertyList();
            for (Property current : keytabList) {
                String[] forHostsValues;
                String principal = current.getName();
                ModelNode keytab = current.getValue();
                String path = KeytabResourceDefinition.PATH.resolveModelAttribute(context, keytab).asString();
                ModelNode relativeToNode = KeytabResourceDefinition.RELATIVE_TO.resolveModelAttribute(context, keytab);
                String relativeTo = relativeToNode.isDefined() ? relativeToNode.asString() : null;
                boolean debug = KeytabResourceDefinition.DEBUG.resolveModelAttribute(context, keytab).asBoolean();
                ModelNode forHosts = KeytabResourceDefinition.FOR_HOSTS.resolveModelAttribute(context, keytab);
                if (forHosts.isDefined()) {
                    List list = forHosts.asList();
                    forHostsValues = new String[list.size()];
                    for (int i = 0; i < list.size(); ++i) {
                        forHostsValues[i] = ((ModelNode)list.get(i)).asString();
                    }
                } else {
                    forHostsValues = new String[]{};
                }
                ServiceName keytabName = KeytabService.ServiceUtil.createServiceName(realmName, principal);
                KeytabService ks = new KeytabService(principal, path, relativeTo, forHostsValues, debug);
                ServiceBuilder keytabBuilder = serviceTarget.addService(keytabName, (Service)ks).setInitialMode(ServiceController.Mode.ON_DEMAND);
                if (relativeTo != null) {
                    keytabBuilder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, ks.getPathManagerInjector());
                    keytabBuilder.addDependency(SecurityRealmAddHandler.pathName(relativeTo));
                }
                keytabBuilder.install();
                KeytabService.ServiceUtil.addDependency(kifsBuilder, kifs.getKeytabInjector(), realmName, principal);
            }
        }
        kifsBuilder.install();
        KeytabIdentityFactoryService.ServiceUtil.addDependency(realmBuilder, injector, realmName);
    }

    private void addUsersService(OperationContext context, ModelNode users, String realmName, ServiceTarget serviceTarget, ServiceBuilder<?> realmBuilder, Injector<CallbackHandlerService> injector) throws OperationFailedException {
        ServiceName usersServiceName = UserDomainCallbackHandler.ServiceUtil.createServiceName(realmName);
        UserDomainCallbackHandler usersCallbackHandler = new UserDomainCallbackHandler(realmName, this.unmaskUsersPasswords(context, users));
        serviceTarget.addService(usersServiceName, (Service)usersCallbackHandler).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        CallbackHandlerService.ServiceUtil.addDependency(realmBuilder, injector, usersServiceName, false);
    }

    private static ServiceName pathName(String relativeTo) {
        return ServiceName.JBOSS.append(new String[]{"server", "path", relativeTo});
    }

    private ModelNode unmaskUsersPasswords(OperationContext context, ModelNode users) throws OperationFailedException {
        users = users.clone();
        for (Property property : users.get("user").asPropertyList()) {
            ModelNode user = users.get(new String[]{"user", property.getName()});
            if (!user.hasDefined("password")) continue;
            user.set("password", context.resolveExpressions(user.get("password")).asString());
        }
        return users;
    }

    private static Map<String, String> resolveProperties(OperationContext context, ModelNode model) throws OperationFailedException {
        Map<String, String> configurationProperties;
        if (model.hasDefined("property")) {
            List propertyList = model.require("property").asPropertyList();
            configurationProperties = new HashMap<String, String>(propertyList.size());
            for (Property current : propertyList) {
                String propertyName = current.getName();
                ModelNode valueNode = PropertyResourceDefinition.VALUE.resolveModelAttribute(context, current.getValue());
                String value = valueNode.isDefined() ? valueNode.asString() : null;
                configurationProperties.put(propertyName, value);
            }
            configurationProperties = Collections.unmodifiableMap(configurationProperties);
        } else {
            configurationProperties = Collections.emptyMap();
        }
        return configurationProperties;
    }

    private static class ServiceInstallStepHandler
    implements OperationStepHandler {
        private static final ServiceInstallStepHandler INSTANCE = new ServiceInstallStepHandler();

        private ServiceInstallStepHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            final ArrayList newControllers = new ArrayList();
            String realmName = ManagementUtil.getSecurityRealmName(operation);
            ModelNode model = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
            INSTANCE.installServices(context, realmName, model);
            context.completeStep(new OperationContext.RollbackHandler(){

                public void handleRollback(OperationContext context, ModelNode operation) {
                    for (ServiceController sc : newControllers) {
                        context.removeService(sc);
                    }
                }
            });
        }
    }
}

