/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import org.jboss.as.domain.management.CallbackHandlerFactory;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class SecretIdentityService
implements Service<CallbackHandlerFactory> {
    private static final String SERVICE_SUFFIX = "secret";
    private final String password;
    private final boolean base64;
    private volatile CallbackHandlerFactory factory;

    public SecretIdentityService(String password, boolean base64) {
        this.password = password;
        this.base64 = base64;
    }

    public void start(StartContext startContext) throws StartException {
        char[] thePassword;
        if (this.base64) {
            String trimmedPassword;
            byte[] value = Base64.getDecoder().decode(this.password);
            String tempPassword = new String(value, StandardCharsets.ISO_8859_1);
            if (!tempPassword.equals(trimmedPassword = tempPassword.trim())) {
                DomainManagementLogger.ROOT_LOGGER.whitespaceTrimmed();
            }
            thePassword = trimmedPassword.toCharArray();
        } else {
            thePassword = this.password.toCharArray();
        }
        this.factory = new CallbackHandlerFactory(){

            @Override
            public CallbackHandler getCallbackHandler(String username) {
                return new SecretCallbackHandler(username, thePassword);
            }
        };
    }

    public void stop(StopContext stopContext) {
        this.factory = null;
    }

    public CallbackHandlerFactory getValue() throws IllegalStateException, IllegalArgumentException {
        return this.factory;
    }

    public static final class ServiceUtil {
        private ServiceUtil() {
        }

        public static ServiceName createServiceName(String realmName) {
            return SecurityRealm.ServiceUtil.createServiceName(realmName).append(new String[]{SecretIdentityService.SERVICE_SUFFIX});
        }
    }

    private class SecretCallbackHandler
    implements CallbackHandler {
        private final String userName;
        private final char[] password;

        SecretCallbackHandler(String userName, char[] password) {
            this.userName = userName;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback current : callbacks) {
                if (current instanceof RealmCallback) {
                    RealmCallback rcb = (RealmCallback)current;
                    String defaultText = rcb.getDefaultText();
                    rcb.setText(defaultText);
                    continue;
                }
                if (current instanceof RealmChoiceCallback) {
                    throw DomainManagementLogger.ROOT_LOGGER.realmNotSupported(current);
                }
                if (current instanceof NameCallback) {
                    NameCallback ncb = (NameCallback)current;
                    ncb.setName(this.userName);
                    continue;
                }
                if (current instanceof PasswordCallback) {
                    PasswordCallback pcb = (PasswordCallback)current;
                    pcb.setPassword(this.password);
                    continue;
                }
                throw new UnsupportedCallbackException(current);
            }
        }
    }
}

