/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.audit;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.audit.AbstractFileAuditLogHandler;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.audit.SizeRotatingFileAuditLogHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.domain.management._private.DomainManagementResolver;
import org.jboss.as.domain.management.audit.AbstractFileAuditLogHandlerResourceDefinition;
import org.jboss.as.domain.management.audit.AuditLogHandlerResourceDefinition;
import org.jboss.as.domain.management.audit.validators.SizeValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SizeRotatingFileAuditLogHandlerResourceDefinition
extends AbstractFileAuditLogHandlerResourceDefinition {
    public static final SimpleAttributeDefinition ROTATE_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("rotate-size", ModelType.STRING).setAllowNull(true)).setAllowExpression(true)).setDefaultValue(new ModelNode("10m"))).setValidator((ParameterValidator)new SizeValidator())).setMinSize(1)).build();
    public static final SimpleAttributeDefinition MAX_BACKUP_INDEX = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-backup-index", ModelType.INT).setAllowNull(true)).setAllowExpression(true)).setDefaultValue(new ModelNode(1))).setValidator((ParameterValidator)new IntRangeValidator(1, true))).setMinSize(1)).build();
    protected static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{ROTATE_SIZE, MAX_BACKUP_INDEX};
    protected static final AttributeDefinition[] FULL_ATTRIBUTES = SizeRotatingFileAuditLogHandlerResourceDefinition.joinArrays(ATTRIBUTES, AbstractFileAuditLogHandlerResourceDefinition.ATTRIBUTES);

    public SizeRotatingFileAuditLogHandlerResourceDefinition(ManagedAuditLogger auditLogger, PathManagerService pathManager) {
        super(auditLogger, pathManager, PathElement.pathElement((String)"size-rotating-file-handler"), DomainManagementResolver.getResolver("core.management.size-rotating-file-handler"), (OperationStepHandler)new SizeRotatingFileAuditLogHandlerAddHandler(auditLogger, pathManager, FULL_ATTRIBUTES), (OperationStepHandler)new AuditLogHandlerResourceDefinition.HandlerRemoveHandler(auditLogger));
    }

    public static ModelNode createServerAddOperation(PathAddress address, ModelNode fileHandler) {
        ModelNode add = Util.createAddOperation((PathAddress)address);
        for (AttributeDefinition def : FULL_ATTRIBUTES) {
            if (!fileHandler.get(def.getName()).isDefined()) continue;
            add.get(def.getName()).set(fileHandler.get(def.getName()));
        }
        return add;
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        AuditLogHandlerResourceDefinition.HandlerWriteAttributeHandler write = this.getWriteAttributeHandler(this.auditLogger, this.pathManager, ATTRIBUTES);
        for (AttributeDefinition def : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(def, null, (OperationStepHandler)write);
        }
    }

    @Override
    protected AuditLogHandlerResourceDefinition.HandlerWriteAttributeHandler getWriteAttributeHandler(ManagedAuditLogger auditLogger, PathManagerService pathManager, AttributeDefinition ... attributeDefinitions) {
        return new SizeRotatingHandlerWriteAttributeHandler(auditLogger, pathManager, attributeDefinitions);
    }

    private static SizeRotatingFileAuditLogHandler createSizeRotatingFileAuditLogHandler(PathManagerService pathManager, OperationContext context, ModelNode operation) throws OperationFailedException {
        String name = Util.getNameFromAddress((ModelNode)operation.require("address"));
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        String relativeTo = model.hasDefined(RELATIVE_TO.getName()) ? RELATIVE_TO.resolveModelAttribute(context, model).asString() : null;
        String path = PATH.resolveModelAttribute(context, model).asString();
        String formatterName = FORMATTER.resolveModelAttribute(context, model).asString();
        int maxFailureCount = MAX_FAILURE_COUNT.resolveModelAttribute(context, model).asInt();
        long rotateSize = SizeValidator.parseSize(ROTATE_SIZE.resolveModelAttribute(context, model));
        int maxBackupIndex = MAX_BACKUP_INDEX.resolveModelAttribute(context, model).asInt();
        return new SizeRotatingFileAuditLogHandler(name, formatterName, maxFailureCount, pathManager, path, relativeTo, rotateSize, maxBackupIndex);
    }

    protected static class SizeRotatingHandlerWriteAttributeHandler
    extends AbstractFileAuditLogHandlerResourceDefinition.AbstractFileAuditLogHandlerWriteAttributeHandler {
        public SizeRotatingHandlerWriteAttributeHandler(ManagedAuditLogger auditLogger, PathManagerService pathManager, AttributeDefinition ... attributeDefinitions) {
            super(auditLogger, pathManager, attributeDefinitions);
        }

        @Override
        protected AbstractFileAuditLogHandler createHandler(PathManagerService pathManager, OperationContext context, ModelNode operation) throws OperationFailedException {
            return SizeRotatingFileAuditLogHandlerResourceDefinition.createSizeRotatingFileAuditLogHandler(pathManager, context, operation);
        }
    }

    protected static class SizeRotatingFileAuditLogHandlerAddHandler
    extends AbstractFileAuditLogHandlerResourceDefinition.AbstractFileAuditLogHandlerAddHandler {
        protected SizeRotatingFileAuditLogHandlerAddHandler(ManagedAuditLogger auditLogger, PathManagerService pathManager, AttributeDefinition[] attributes) {
            super(auditLogger, pathManager, attributes);
        }

        @Override
        protected AbstractFileAuditLogHandler createHandler(PathManagerService pathManager, OperationContext context, ModelNode operation) throws OperationFailedException {
            return SizeRotatingFileAuditLogHandlerResourceDefinition.createSizeRotatingFileAuditLogHandler(pathManager, context, operation);
        }
    }
}

