/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.jboss.as.domain.management.AuthMechanism;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.CallbackHandlerService;
import org.jboss.as.domain.management.security.UserNotFoundException;
import org.jboss.as.domain.management.security.UserPropertiesFileLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.callback.EvidenceVerifyCallback;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.password.interfaces.DigestPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.password.spec.DigestPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.DigestPasswordSpec;
import org.wildfly.security.password.spec.EncryptablePasswordSpec;
import org.wildfly.security.sasl.util.UsernamePasswordHashUtil;
import org.wildfly.security.util.ByteIterator;

public class PropertiesCallbackHandler
extends UserPropertiesFileLoader
implements Service<CallbackHandlerService>,
CallbackHandlerService,
CallbackHandler {
    private static final String SERVICE_SUFFIX = "properties_authentication";
    private static UsernamePasswordHashUtil hashUtil = null;
    private final String realm;
    private final boolean plainText;

    public PropertiesCallbackHandler(String realm, String path, String relativeTo, boolean plainText) {
        super(path, relativeTo);
        this.realm = realm;
        this.plainText = plainText;
    }

    @Override
    public AuthMechanism getPreferredMechanism() {
        return AuthMechanism.DIGEST;
    }

    @Override
    public Set<AuthMechanism> getSupplementaryMechanisms() {
        return Collections.singleton(AuthMechanism.PLAIN);
    }

    @Override
    public Map<String, String> getConfigurationOptions() {
        HashMap<String, String> response = new HashMap<String, String>(2);
        response.put("org.jboss.as.domain.management.digest.plain_text", Boolean.toString(this.plainText));
        response.put("org.jboss.as.domain.management.verify_password_callback_supported", Boolean.TRUE.toString());
        return response;
    }

    @Override
    public boolean isReadyForHttpChallenge() {
        Properties users;
        try {
            users = this.getProperties();
        }
        catch (IOException e) {
            return false;
        }
        return users.size() > 0;
    }

    @Override
    public CallbackHandler getCallbackHandler(Map<String, Object> sharedState) {
        return this;
    }

    @Override
    public SecurityRealm getElytronSecurityRealm() {
        return new SecurityRealmImpl();
    }

    @Override
    protected void verifyProperties(Properties properties) throws IOException {
        String admin = "admin";
        if (properties.contains("admin") && "admin".equals(properties.get("admin"))) {
            DomainManagementLogger.ROOT_LOGGER.userAndPasswordWarning();
        }
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        try {
            String fileRealm = this.getRealmName();
            if (fileRealm != null && !this.realm.equals(this.getRealmName())) {
                DomainManagementLogger.ROOT_LOGGER.realmMisMatch(this.realm, fileRealm);
            }
        }
        catch (IOException e) {
            throw DomainManagementLogger.ROOT_LOGGER.unableToLoadProperties(e);
        }
    }

    public CallbackHandlerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        LinkedList<Callback> toRespondTo = new LinkedList<Callback>();
        String userName = null;
        boolean userFound = false;
        Properties users = this.getProperties();
        for (Callback current : callbacks) {
            if (current instanceof AuthorizeCallback) {
                toRespondTo.add(current);
                continue;
            }
            if (current instanceof NameCallback) {
                NameCallback nameCallback = (NameCallback)current;
                userName = nameCallback.getDefaultName();
                userFound = users.containsKey(userName);
                continue;
            }
            if (current instanceof PasswordCallback && this.plainText) {
                toRespondTo.add(current);
                continue;
            }
            if (current instanceof CredentialCallback) {
                toRespondTo.add(current);
                continue;
            }
            if (current instanceof EvidenceVerifyCallback && ((EvidenceVerifyCallback)current).getEvidence() instanceof PasswordGuessEvidence) {
                toRespondTo.add(current);
                continue;
            }
            if (current instanceof RealmCallback) {
                String realm = ((RealmCallback)current).getDefaultText();
                if (this.realm.equals(realm)) continue;
                throw DomainManagementLogger.ROOT_LOGGER.invalidRealm(realm, this.realm);
            }
            throw new UnsupportedCallbackException(current);
        }
        for (Callback current : toRespondTo) {
            String hash;
            UsernamePasswordHashUtil hashUtil;
            if (current instanceof AuthorizeCallback) {
                AuthorizeCallback acb = (AuthorizeCallback)current;
                boolean authorized = acb.getAuthenticationID().equals(acb.getAuthorizationID());
                if (!authorized) {
                    DomainManagementLogger.SECURITY_LOGGER.tracef("Checking 'AuthorizeCallback', authorized=false, authenticationID=%s, authorizationID=%s.", acb.getAuthenticationID(), acb.getAuthorizationID());
                }
                acb.setAuthorized(authorized);
                continue;
            }
            if (current instanceof PasswordCallback) {
                if (!userFound) {
                    DomainManagementLogger.SECURITY_LOGGER.tracef("User '%s' not found in properties file.", userName);
                    throw new UserNotFoundException(userName);
                }
                String password = users.get(userName).toString();
                ((PasswordCallback)current).setPassword(password.toCharArray());
                continue;
            }
            if (current instanceof CredentialCallback) {
                ClearPassword password;
                if (!userFound) {
                    DomainManagementLogger.SECURITY_LOGGER.tracef("User '%s' not found in properties file.", userName);
                    throw new UserNotFoundException(userName);
                }
                CredentialCallback cc = (CredentialCallback)current;
                if (!PasswordCredential.class.isAssignableFrom(cc.getCredentialType())) continue;
                String algorithmName = cc.getAlgorithm();
                if ((algorithmName == null || "clear".equals(algorithmName)) && this.plainText) {
                    password = ClearPassword.createRaw((String)"clear", (char[])((String)users.get(userName)).toCharArray());
                } else {
                    if (algorithmName != null && !"digest-md5".equals(algorithmName) || this.plainText) continue;
                    byte[] hashed = ByteIterator.ofBytes((byte[])((String)users.get(userName)).getBytes(StandardCharsets.UTF_8)).hexDecode().drain();
                    password = DigestPassword.createRaw((String)"digest-md5", (String)userName, (String)this.realm, (byte[])hashed);
                }
                cc.setCredential((Credential)cc.getCredentialType().cast(new PasswordCredential((Password)password)));
                continue;
            }
            if (!(current instanceof EvidenceVerifyCallback)) continue;
            if (!userFound) {
                DomainManagementLogger.SECURITY_LOGGER.tracef("User '%s' not found in properties file.", userName);
                throw new UserNotFoundException(userName);
            }
            EvidenceVerifyCallback evc = (EvidenceVerifyCallback)current;
            PasswordGuessEvidence evidence = (PasswordGuessEvidence)evc.getEvidence();
            char[] guess = evidence.getGuess();
            if (this.plainText) {
                String password = users.get(userName).toString();
                boolean verified = password.equals(new String(guess));
                if (!verified) {
                    DomainManagementLogger.SECURITY_LOGGER.tracef("Password verification failed for user '%s'", userName);
                }
                evc.setVerified(verified);
                continue;
            }
            UsernamePasswordHashUtil usernamePasswordHashUtil = hashUtil = PropertiesCallbackHandler.getHashUtil();
            synchronized (usernamePasswordHashUtil) {
                hash = hashUtil.generateHashedHexURP(userName, this.realm, guess);
            }
            String expected = users.get(userName).toString();
            boolean verified = expected.equals(hash);
            if (!verified) {
                DomainManagementLogger.SECURITY_LOGGER.tracef("Digest verification failed for user '%s'", userName);
            }
            evc.setVerified(verified);
        }
    }

    private static UsernamePasswordHashUtil getHashUtil() {
        if (hashUtil == null) {
            try {
                hashUtil = new UsernamePasswordHashUtil();
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException(e);
            }
        }
        return hashUtil;
    }

    private static PasswordFactory getPasswordFactory(String algorithm) {
        try {
            return PasswordFactory.getInstance((String)algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static final class ServiceUtil {
        private ServiceUtil() {
        }

        public static ServiceName createServiceName(String realmName) {
            return SecurityRealm.ServiceUtil.createServiceName(realmName).append(new String[]{PropertiesCallbackHandler.SERVICE_SUFFIX});
        }
    }

    private class SecurityRealmImpl
    implements SecurityRealm {
        private SecurityRealmImpl() {
        }

        public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
            try {
                Properties users = PropertiesCallbackHandler.this.getProperties();
                String name = principal.getName();
                return new RealmIdentityImpl(principal, users.getProperty(name));
            }
            catch (IOException e) {
                throw new RealmUnavailableException((Throwable)e);
            }
        }

        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            return PasswordCredential.class.isAssignableFrom(credentialType) && (algorithmName == null || algorithmName.equals("clear") && PropertiesCallbackHandler.this.plainText || algorithmName.equals("digest-md5")) ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
        }

        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return PasswordGuessEvidence.class.isAssignableFrom(evidenceType) ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
        }

        private class RealmIdentityImpl
        implements RealmIdentity {
            private final Principal principal;
            private final String password;

            private RealmIdentityImpl(Principal principal, String password) {
                this.principal = principal;
                this.password = password;
            }

            public Principal getRealmIdentityPrincipal() {
                return this.principal;
            }

            public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
                return SecurityRealmImpl.this.getCredentialAcquireSupport(credentialType, algorithmName);
            }

            public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
                return this.getCredential(credentialType, null);
            }

            public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
                ClearPasswordSpec passwordSpec;
                PasswordFactory passwordFactory;
                boolean clear;
                if (this.password == null || !PasswordCredential.class.isAssignableFrom(credentialType)) {
                    return null;
                }
                if (algorithmName == null) {
                    clear = PropertiesCallbackHandler.this.plainText;
                } else if ("clear".equals(algorithmName)) {
                    clear = true;
                } else if ("digest-md5".equals(algorithmName)) {
                    clear = false;
                } else {
                    return null;
                }
                if (clear) {
                    passwordFactory = PropertiesCallbackHandler.getPasswordFactory("clear");
                    passwordSpec = new ClearPasswordSpec(this.password.toCharArray());
                } else {
                    passwordFactory = PropertiesCallbackHandler.getPasswordFactory("digest-md5");
                    if (PropertiesCallbackHandler.this.plainText) {
                        DigestPasswordAlgorithmSpec algorithmParameterSpec = new DigestPasswordAlgorithmSpec(this.principal.getName(), PropertiesCallbackHandler.this.realm);
                        passwordSpec = new EncryptablePasswordSpec(this.password.toCharArray(), (AlgorithmParameterSpec)algorithmParameterSpec);
                    } else {
                        byte[] hashed = ByteIterator.ofBytes((byte[])this.password.getBytes(StandardCharsets.UTF_8)).hexDecode().drain();
                        passwordSpec = new DigestPasswordSpec(this.principal.getName(), PropertiesCallbackHandler.this.realm, hashed);
                    }
                }
                try {
                    return (C)((Credential)credentialType.cast(new PasswordCredential(passwordFactory.generatePassword((KeySpec)passwordSpec))));
                }
                catch (InvalidKeySpecException e) {
                    throw new IllegalStateException(e);
                }
            }

            public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
                return SecurityRealmImpl.this.getEvidenceVerifySupport(evidenceType, algorithmName);
            }

            public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
                ClearPasswordSpec passwordSpec;
                PasswordFactory passwordFactory;
                if (this.password == null || !(evidence instanceof PasswordGuessEvidence)) {
                    return false;
                }
                char[] guess = ((PasswordGuessEvidence)evidence).getGuess();
                if (PropertiesCallbackHandler.this.plainText) {
                    passwordFactory = PropertiesCallbackHandler.getPasswordFactory("clear");
                    passwordSpec = new ClearPasswordSpec(this.password.toCharArray());
                } else {
                    passwordFactory = PropertiesCallbackHandler.getPasswordFactory("digest-md5");
                    byte[] hashed = ByteIterator.ofBytes((byte[])this.password.getBytes(StandardCharsets.UTF_8)).hexDecode().drain();
                    passwordSpec = new DigestPasswordSpec(this.principal.getName(), PropertiesCallbackHandler.this.realm, hashed);
                }
                try {
                    Password actualPassword = passwordFactory.generatePassword((KeySpec)passwordSpec);
                    return passwordFactory.verify(actualPassword, guess);
                }
                catch (IllegalStateException | InvalidKeyException | InvalidKeySpecException e) {
                    throw new IllegalStateException(e);
                }
            }

            public boolean exists() throws RealmUnavailableException {
                return this.password != null;
            }
        }
    }
}

