/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.security.AuthenticationValidatingHandler;
import org.jboss.as.domain.management.security.SecurityRealmParentRestartHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class SecurityRealmChildRemoveHandler
extends SecurityRealmParentRestartHandler {
    private final boolean validateAuthentication;

    public SecurityRealmChildRemoveHandler(boolean validateAuthentication) {
        this(validateAuthentication, null);
    }

    public SecurityRealmChildRemoveHandler(boolean validateAuthentication, RuntimeCapability ... capabilities) {
        super(capabilities);
        this.validateAuthentication = validateAuthentication;
    }

    @Override
    protected boolean isResourceServiceRestartAllowed(OperationContext context, ServiceController<?> service) {
        return false;
    }

    protected void updateModel(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.readResource(PathAddress.EMPTY_ADDRESS, false);
        Resource resource = context.removeResource(PathAddress.EMPTY_ADDRESS);
        this.recordCapabilitiesAndRequirements(context, operation, resource);
        if (this.validateAuthentication && !context.isBooting()) {
            ModelNode validationOp = AuthenticationValidatingHandler.createOperation(operation);
            context.addStep(validationOp, (OperationStepHandler)AuthenticationValidatingHandler.INSTANCE, OperationContext.Stage.MODEL);
        }
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        Set capabilitySet = this.capabilities.isEmpty() ? context.getResourceRegistration().getCapabilities() : this.capabilities;
        for (RuntimeCapability capability : capabilitySet) {
            if (capability.isDynamicallyNamed()) {
                context.deregisterCapability(capability.getDynamicName(context.getCurrentAddress()));
                continue;
            }
            context.deregisterCapability(capability.getName());
        }
        ModelNode model = resource.getModel();
        ImmutableManagementResourceRegistration mrr = context.getResourceRegistration();
        for (String attr : mrr.getAttributeNames(PathAddress.EMPTY_ADDRESS)) {
            AttributeDefinition ad;
            AttributeAccess aa = mrr.getAttributeAccess(PathAddress.EMPTY_ADDRESS, attr);
            if (aa == null || (ad = aa.getAttributeDefinition()) == null || !model.hasDefined(ad.getName()) && !ad.hasCapabilityRequirements()) continue;
            ad.removeCapabilityRequirements(context, resource, model.get(ad.getName()));
        }
    }
}

