/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.function.Supplier;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.wildfly.common.context.Contextual;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.SecurityActions;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.ElytronXmlParser;
import org.wildfly.security.auth.client.InvalidAuthenticationConfigurationException;

class AuthenticationContextAssociationProcessor
implements DeploymentUnitProcessor {
    AuthenticationContextAssociationProcessor() {
    }

    public void deploy(DeploymentPhaseContext context) throws DeploymentUnitProcessingException {
        AuthenticationContext authenticationContext = (AuthenticationContext)context.getAttachment(ElytronExtension.AUTHENTICATION_CONTEXT_KEY);
        final ModuleClassLoader classLoader = ((Module)context.getDeploymentUnit().getAttachment(Attachments.MODULE)).getClassLoader();
        if (authenticationContext != null) {
            AuthenticationContext.getContextManager().setClassLoaderDefault((ClassLoader)classLoader, (Contextual)authenticationContext);
        } else {
            AuthenticationContext.getContextManager().setClassLoaderDefaultSupplier((ClassLoader)classLoader, (Supplier)new Supplier<AuthenticationContext>(){
                private volatile AuthenticationContext context;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public AuthenticationContext get() {
                    if (this.context != null) {
                        return this.context;
                    }
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.context != null) {
                            return this.context;
                        }
                        this.context = SecurityActions.doPrivileged(() -> {
                            ClassLoader old = Thread.currentThread().getContextClassLoader();
                            try {
                                Thread.currentThread().setContextClassLoader((ClassLoader)classLoader);
                                AuthenticationContext authenticationContext = (AuthenticationContext)ElytronXmlParser.parseAuthenticationClientConfiguration().create();
                                return authenticationContext;
                            }
                            catch (Throwable t) {
                                throw new InvalidAuthenticationConfigurationException(t);
                            }
                            finally {
                                Thread.currentThread().setContextClassLoader(old);
                            }
                        });
                        return this.context;
                    }
                }
            });
        }
    }

    public void undeploy(DeploymentUnit unit) {
        AuthenticationContext.getContextManager().setClassLoaderDefault((ClassLoader)((Module)unit.getAttachment(Attachments.MODULE)).getClassLoader(), null);
    }
}

