/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.Transformers;
import org.jboss.as.domain.controller.operations.ReadDomainModelHandler;
import org.jboss.as.domain.controller.operations.ReadMasterDomainModelUtil;
import org.jboss.as.host.controller.mgmt.HostInfo;
import org.jboss.dmr.ModelNode;

public class ReadMasterDomainModelHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "read-master-domain-model";
    private final HostInfo hostInfo;
    private final Transformers transformers;
    private final ExtensionRegistry extensionRegistry;

    public ReadMasterDomainModelHandler(HostInfo hostInfo, Transformers transformers, ExtensionRegistry extensionRegistry) {
        this.hostInfo = hostInfo;
        this.transformers = transformers;
        this.extensionRegistry = extensionRegistry;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Transformers.ResourceIgnoredTransformationRegistry ignoredTransformationRegistry;
        context.acquireControllerLock();
        Resource resource = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS);
        if (this.hostInfo == null) {
            ignoredTransformationRegistry = Transformers.DEFAULT;
        } else {
            ReadMasterDomainModelUtil.RequiredConfigurationHolder rc = ReadMasterDomainModelUtil.populateHostResolutionContext(this.hostInfo, resource, this.extensionRegistry);
            ignoredTransformationRegistry = ReadMasterDomainModelUtil.createHostIgnoredRegistry(this.hostInfo, rc);
        }
        ReadDomainModelHandler handler = new ReadDomainModelHandler(ignoredTransformationRegistry, this.transformers);
        context.addStep((OperationStepHandler)handler, OperationContext.Stage.MODEL);
    }
}

