/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.HashSet;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.as.server.deploymentoverlay.AffectedDeploymentOverlay;
import org.jboss.dmr.ModelNode;

public class DomainDeploymentOverlayRedeployLinksHandler
implements OperationStepHandler {
    public static final StringListAttributeDefinition RUNTIME_NAMES_DEFINITION = ((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("deployments").setRequired(false)).build();
    public static final OperationDefinition REDEPLOY_LINKS_DEFINITION = new SimpleOperationDefinitionBuilder("redeploy-links", ControllerResolver.getResolver((String[])new String[]{"deployment-overlay"})).addParameter((AttributeDefinition)RUNTIME_NAMES_DEFINITION).build();
    private final boolean domainRoot;

    public DomainDeploymentOverlayRedeployLinksHandler(boolean domainRoot) {
        this.domainRoot = domainRoot;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        HashSet runtimeNames;
        Set set = runtimeNames = this.domainRoot ? AffectedDeploymentOverlay.listAllLinks((OperationContext)context, (String)context.getCurrentAddressValue()) : AffectedDeploymentOverlay.listLinks((OperationContext)context, (PathAddress)context.getCurrentAddress());
        if (operation.hasDefined(RUNTIME_NAMES_DEFINITION.getName())) {
            HashSet requiredRuntimeNames = new HashSet(RUNTIME_NAMES_DEFINITION.unwrap((ExpressionResolver)context, operation));
            Set unaffectedDeployments = AffectedDeploymentOverlay.checkRequiredNames(requiredRuntimeNames, (Set)runtimeNames);
            if (!unaffectedDeployments.isEmpty() && !this.isRedeployAfterRemoval(operation)) {
                throw DomainControllerLogger.ROOT_LOGGER.redeployingUnaffactedDeployments(unaffectedDeployments);
            }
            runtimeNames = requiredRuntimeNames;
        }
        ModelNode removeOperation = null;
        if (this.isRedeployAfterRemoval(operation)) {
            removeOperation = Operations.createRemoveOperation((ModelNode)context.getCurrentAddress().append("deployment", (String)runtimeNames.iterator().next()).toModelNode());
        }
        if (this.domainRoot) {
            AffectedDeploymentOverlay.redeployLinksAndTransformOperationForDomain((OperationContext)context, (Set)runtimeNames, removeOperation);
        } else {
            AffectedDeploymentOverlay.redeployLinksAndTransformOperation((OperationContext)context, removeOperation, (PathAddress)context.getCurrentAddress().getParent(), (Set)runtimeNames);
        }
    }

    private boolean isRedeployAfterRemoval(ModelNode operation) {
        return operation.hasDefined("deployment-overlay-link-removal") && operation.get("deployment-overlay-link-removal").asBoolean();
    }
}

