/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.transformers;

import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ChainedTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.OperationTransformationOverrideBuilder;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.as.domain.controller.transformers.DomainTransformers;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.controller.resources.DeploymentResourceDefinition;
import org.jboss.dmr.ModelNode;

class DeploymentTransformers {
    private static final RejectAttributeChecker EXPLODED_REJECT = new RejectAttributeChecker.ListRejectAttributeChecker((RejectAttributeChecker)new RejectAttributeChecker.DefaultRejectAttributeChecker(){

        protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            if (!DeploymentAttributes.isUnmanagedContent((ModelNode)attributeValue)) {
                return attributeValue.hasDefined("archive") && !attributeValue.get("archive").asBoolean(true);
            }
            return false;
        }

        public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
            return ControllerLogger.ROOT_LOGGER.explodedDeploymentNotSupported();
        }
    });
    private static final AttributeConverter ARCHIVE_REMOVER = new AttributeConverter.DefaultAttributeConverter(){

        protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            if (attributeValue.isDefined()) {
                for (ModelNode content : attributeValue.asList()) {
                    if (DeploymentAttributes.isUnmanagedContent((ModelNode)content) || !content.hasDefined("archive") || !content.get("archive").asBoolean(true)) continue;
                    content.remove("archive");
                }
            }
        }
    };

    DeploymentTransformers() {
    }

    public static ChainedTransformationDescriptionBuilder buildTransformerChain(ModelVersion currentVersion) {
        ChainedTransformationDescriptionBuilder chainedBuilder = TransformationDescriptionBuilder.Factory.createChainedInstance((PathElement)DeploymentResourceDefinition.PATH, (ModelVersion)currentVersion);
        ResourceTransformationDescriptionBuilder builder = chainedBuilder.createBuilder(currentVersion, DomainTransformers.VERSION_4_1);
        ((OperationTransformationOverrideBuilder)((OperationTransformationOverrideBuilder)((OperationTransformationOverrideBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().addRejectCheck(EXPLODED_REJECT, new AttributeDefinition[]{DeploymentAttributes.CONTENT_ALL})).setValueConverter(ARCHIVE_REMOVER, new AttributeDefinition[]{DeploymentAttributes.CONTENT_ALL})).end().addOperationTransformationOverride("read-attribute").setDiscard(DiscardAttributeChecker.ALWAYS, new AttributeDefinition[]{DeploymentAttributes.MANAGED})).end().addOperationTransformationOverride("add").addRejectCheck(EXPLODED_REJECT, new AttributeDefinition[]{DeploymentAttributes.CONTENT_ALL})).setValueConverter(ARCHIVE_REMOVER, new AttributeDefinition[]{DeploymentAttributes.CONTENT_ALL})).end().discardOperations(new String[]{"browse-content", "read-content", "explode", "add-content", "remove-content"});
        return chainedBuilder;
    }
}

