package org.wildfly.core.launcher.logger;

import java.util.Locale;
import java.nio.file.Path;
import java.io.Serializable;
import javax.annotation.Generated;
import java.lang.CharSequence;
import java.lang.String;
import java.util.Arrays;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageBundleImplementor", date = "2017-08-22T14:24:41-0500")
public class LauncherMessages_$bundle implements LauncherMessages, Serializable {
    private static final long serialVersionUID = 1L;
    protected LauncherMessages_$bundle() {}
    public static final LauncherMessages_$bundle INSTANCE = new LauncherMessages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String pathDoesNotExist = "WFLYLNCHR0001: The path '%s' does not exist";
    protected String pathDoesNotExist$str() {
        return pathDoesNotExist;
    }
    @Override
    public final IllegalArgumentException pathDoesNotExist(final Path path) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), pathDoesNotExist$str(), path));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidDirectory1 = "WFLYLNCHR0002: The directory '%s' is not a valid directory";
    protected String invalidDirectory1$str() {
        return invalidDirectory1;
    }
    @Override
    public final IllegalArgumentException invalidDirectory(final Path dir) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidDirectory1$str(), dir));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidDirectory2 = "WFLYLNCHR0003: Invalid directory, could not find '%s' in '%s'";
    protected String invalidDirectory2$str() {
        return invalidDirectory2;
    }
    @Override
    public final IllegalArgumentException invalidDirectory(final String filename, final Path dir) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidDirectory2$str(), filename, dir));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String pathNotAFile = "WFLYLNCHR0004: Path '%s' is not a regular file.";
    protected String pathNotAFile$str() {
        return pathNotAFile;
    }
    @Override
    public final IllegalArgumentException pathNotAFile(final Path path) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), pathNotAFile$str(), path));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullParam = "WFLYLNCHR0005: The parameter %s cannot be null.";
    protected String nullParam$str() {
        return nullParam;
    }
    @Override
    public final IllegalArgumentException nullParam(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullParam$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidHostname = "WFLYLNCHR0006: Invalid hostname: %s";
    protected String invalidHostname$str() {
        return invalidHostname;
    }
    @Override
    public final IllegalArgumentException invalidHostname(final CharSequence hostname) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidHostname$str(), hostname));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
