/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.management.client.content;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.management.client.content.ContentStorageException;
import org.jboss.as.management.client.content.ManagedDMRContentLogger;
import org.jboss.as.management.client.content.ManagedDMRContentTypeResource;
import org.jboss.dmr.ModelNode;

public class ManagedDMRContentResource
implements Resource.ResourceEntry {
    private final PathElement pathElement;
    private ManagedDMRContentTypeResource parent;
    private ModelNode model;

    public ManagedDMRContentResource(PathElement pathElement) {
        this(pathElement, null);
    }

    public ManagedDMRContentResource(PathElement pathElement, ManagedDMRContentTypeResource parent) {
        this.pathElement = pathElement;
        this.parent = parent;
    }

    void setParent(ManagedDMRContentTypeResource parent) {
        this.parent = parent;
    }

    public synchronized ModelNode getModel() {
        if (this.model == null) {
            ManagedDMRContentTypeResource.ManagedContent content;
            this.model = new ModelNode();
            if (this.parent != null && (content = this.parent.getManagedContent(this.pathElement.getValue())) != null) {
                this.model.get("hash").set(content.getHash());
                this.model.get("content").set(content.getContent());
            }
        }
        return this.model;
    }

    public synchronized void writeModel(ModelNode newModel) {
        if (this.parent == null) {
            throw ManagedDMRContentLogger.ROOT_LOGGER.nullParent();
        }
        ModelNode content = newModel.get("content");
        try {
            byte[] hash = this.parent.storeManagedContent(this.pathElement.getValue(), content);
            newModel.get("hash").set(hash);
            this.model = null;
        }
        catch (IOException e) {
            throw new ContentStorageException(e);
        }
    }

    public boolean isModelDefined() {
        return this.getModel().isDefined();
    }

    public boolean hasChild(PathElement element) {
        return false;
    }

    public Resource getChild(PathElement element) {
        return null;
    }

    public Resource requireChild(PathElement element) {
        throw new Resource.NoSuchResourceException(element);
    }

    public boolean hasChildren(String childType) {
        return false;
    }

    public Resource navigate(PathAddress address) {
        return Resource.Tools.navigate((Resource)this, (PathAddress)address);
    }

    public Set<String> getChildTypes() {
        return Collections.emptySet();
    }

    public Set<String> getChildrenNames(String childType) {
        return Collections.emptySet();
    }

    public Set<Resource.ResourceEntry> getChildren(String childType) {
        return Collections.emptySet();
    }

    public void registerChild(PathElement address, Resource resource) {
        throw ControllerLogger.ROOT_LOGGER.immutableResource();
    }

    public void registerChild(PathElement address, int index, Resource resource) {
        throw ControllerLogger.ROOT_LOGGER.immutableResource();
    }

    public Resource removeChild(PathElement address) {
        return null;
    }

    public boolean isRuntime() {
        return true;
    }

    public boolean isProxy() {
        return false;
    }

    public Resource clone() {
        return new ManagedDMRContentResource(this.pathElement, this.parent);
    }

    public String getName() {
        return this.pathElement.getValue();
    }

    public PathElement getPathElement() {
        return this.pathElement;
    }

    public Set<String> getOrderedChildTypes() {
        return Collections.emptySet();
    }
}

