/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.tool;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.patching.PatchInfo;
import org.jboss.as.patching.PatchingException;
import org.jboss.as.patching.installation.InstallationManager;
import org.jboss.as.patching.installation.LayersConfig;
import org.jboss.as.patching.logging.PatchLogger;
import org.jboss.as.patching.metadata.MiscContentItem;
import org.jboss.as.patching.runner.PatchToolImpl;
import org.jboss.as.patching.runner.PatchUtils;
import org.jboss.as.patching.tool.ContentPolicyBuilderImpl;
import org.jboss.as.patching.tool.ContentVerificationPolicy;
import org.jboss.as.patching.tool.PatchingHistory;
import org.jboss.as.patching.tool.PatchingResult;
import org.jboss.as.version.ProductConfig;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.LocalModuleLoader;
import org.jboss.modules.ModuleLoader;

public interface PatchTool {
    public static final ContentVerificationPolicy DEFAULT = ContentVerificationPolicy.STRICT;

    public PatchInfo getPatchInfo();

    public PatchingHistory getPatchingHistory();

    public PatchingResult applyPatch(File var1, ContentVerificationPolicy var2) throws PatchingException;

    public PatchingResult applyPatch(URL var1, ContentVerificationPolicy var2) throws PatchingException;

    public PatchingResult applyPatch(InputStream var1, ContentVerificationPolicy var2) throws PatchingException;

    public PatchingResult rollback(String var1, ContentVerificationPolicy var2, boolean var3, boolean var4) throws PatchingException;

    public PatchingResult rollbackLast(ContentVerificationPolicy var1, boolean var2) throws PatchingException;

    public static interface ContentPolicyBuilder {
        public ContentVerificationPolicy createPolicy();

        public ContentPolicyBuilder ignoreModuleChanges();

        public ContentPolicyBuilder overrideAll();

        public ContentPolicyBuilder overrideItem(MiscContentItem var1);

        public ContentPolicyBuilder overrideItem(String var1);

        public ContentPolicyBuilder preserveItem(MiscContentItem var1);

        public ContentPolicyBuilder preserveItem(String var1);
    }

    public static class Factory {
        private Factory() {
        }

        public static ContentPolicyBuilder policyBuilder() {
            return new ContentPolicyBuilderImpl();
        }

        public static ContentVerificationPolicy create(ModelNode operation) {
            boolean overrideAll;
            ContentPolicyBuilder builder = Factory.policyBuilder();
            boolean overrideModules = operation.get("override-modules").asBoolean(false);
            if (overrideModules) {
                builder.ignoreModuleChanges();
            }
            if (overrideAll = operation.get("override-all").asBoolean(false)) {
                builder.overrideAll();
            }
            if (operation.hasDefined("override")) {
                ModelNode overrides = operation.get("override");
                for (ModelNode override : overrides.asList()) {
                    builder.overrideItem(override.asString());
                }
            }
            if (operation.hasDefined("preserve")) {
                ModelNode preserves = operation.get("preserve");
                for (ModelNode preserve : preserves.asList()) {
                    builder.preserveItem(preserve.asString());
                }
            }
            return builder.createPolicy();
        }

        public static PatchTool createLocalTool(File jbossHome, List<File> moduleRoots, List<File> bundleRoots) throws IOException {
            File[] resolvedPath = Factory.resolveLayeredModulePath(moduleRoots);
            LocalModuleLoader loader = new LocalModuleLoader(resolvedPath);
            ProductConfig config = new ProductConfig((ModuleLoader)loader, jbossHome.getAbsolutePath(), Collections.emptyMap());
            InstallationManager manager = InstallationManager.load(jbossHome, moduleRoots, bundleRoots, config);
            return Factory.create(manager);
        }

        public static PatchTool create(InstallationManager manager) {
            return new PatchToolImpl(manager);
        }

        private static File[] resolveLayeredModulePath(List<File> modulePath) {
            boolean foundLayers = false;
            ArrayList<File> layeredPath = new ArrayList<File>();
            for (File file : modulePath) {
                layeredPath.add(file);
                LayersConfig layersConfig = Factory.getLayersConfig(file);
                File layersDir = new File(file, layersConfig.getLayersPath());
                if (!layersDir.exists()) {
                    if (!layersConfig.isConfigured()) continue;
                    throw PatchLogger.ROOT_LOGGER.installationNoLayersConfigFound(layersDir.getAbsolutePath());
                }
                boolean validLayers = true;
                ArrayList<File> layerFiles = new ArrayList<File>();
                for (String layerName : layersConfig.getLayers()) {
                    File layer = new File(layersDir, layerName);
                    if (!layer.exists()) {
                        if (layersConfig.isConfigured()) {
                            throw PatchLogger.ROOT_LOGGER.installationMissingLayer(layerName, layersDir.getAbsolutePath());
                        }
                        validLayers = false;
                        break;
                    }
                    Factory.loadOverlays(layer, layerFiles);
                }
                if (!validLayers) continue;
                foundLayers = true;
                layeredPath.addAll(layerFiles);
                File[] addOns = new File(file, layersConfig.getAddOnsPath()).listFiles();
                if (addOns == null) continue;
                for (File addOn : addOns) {
                    if (!addOn.isDirectory()) continue;
                    Factory.loadOverlays(addOn, layeredPath);
                }
            }
            return foundLayers ? layeredPath.toArray(new File[layeredPath.size()]) : modulePath.toArray(new File[modulePath.size()]);
        }

        private static LayersConfig getLayersConfig(File repoRoot) {
            try {
                return LayersConfig.getLayersConfig(repoRoot);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        static void loadOverlays(File layeringRoot, List<File> path) {
            File refs;
            File overlays = new File(layeringRoot, ".overlays");
            if (overlays.exists() && (refs = new File(overlays, ".overlays")).exists()) {
                try {
                    for (String overlay : PatchUtils.readRefs(refs)) {
                        File root = new File(overlays, overlay);
                        path.add(root);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            path.add(layeringRoot);
        }
    }
}

