/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.management;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.patching.PatchingException;
import org.jboss.as.patching.installation.InstallationManager;
import org.jboss.as.patching.installation.InstallationManagerService;
import org.jboss.as.patching.logging.PatchLogger;
import org.jboss.as.patching.management.PatchResourceDefinition;
import org.jboss.as.patching.management.PatchStreamResourceOperationStepHandler;
import org.jboss.as.patching.tool.ContentVerificationPolicy;
import org.jboss.as.patching.tool.PatchOperationTarget;
import org.jboss.as.patching.tool.PatchTool;
import org.jboss.as.patching.tool.PatchingResult;
import org.jboss.dmr.ModelNode;

public class LocalPatchRollbackHandler
extends PatchStreamResourceOperationStepHandler {
    public static final LocalPatchRollbackHandler INSTANCE = new LocalPatchRollbackHandler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute(OperationContext context, ModelNode operation, final InstallationManager installationManager, String patchStream) throws OperationFailedException {
        if (installationManager.requiresRestart()) {
            throw PatchLogger.ROOT_LOGGER.serverRequiresRestart();
        }
        String patchId = PatchResourceDefinition.PATCH_ID.resolveModelAttribute(context, operation).asString();
        boolean rollbackTo = PatchResourceDefinition.ROLLBACK_TO.resolveModelAttribute(context, operation).asBoolean();
        boolean restoreConfiguration = PatchResourceDefinition.RESET_CONFIGURATION.resolveModelAttribute(context, operation).asBoolean();
        PatchTool runner = PatchTool.Factory.create(installationManager);
        ContentVerificationPolicy policy = PatchTool.Factory.create(operation);
        try {
            final PatchingResult result = runner.rollback(patchStream, patchId, policy, rollbackTo, restoreConfiguration);
            installationManager.restartRequired();
            context.restartRequired();
            context.completeStep(new OperationContext.ResultHandler(){

                public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                    if (resultAction == OperationContext.ResultAction.KEEP) {
                        result.commit();
                    } else {
                        installationManager.clearRestartRequired();
                        context.revertRestartRequired();
                        result.rollback();
                    }
                }
            });
        }
        catch (PatchingException e) {
            ModelNode failureDescription = context.getFailureDescription();
            PatchOperationTarget.formatFailedResponse(e, failureDescription);
            installationManager.clearRestartRequired();
        }
    }

    @Override
    protected InstallationManager getInstallationManager(OperationContext ctx) {
        return (InstallationManager)ctx.getServiceRegistry(true).getRequiredService(InstallationManagerService.NAME).getValue();
    }
}

