/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.management;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collection;
import org.jboss.as.patching.logging.PatchLogger;

class DeleteOp {
    public static final String BACKUP_FOLDER = ".bkp";
    private final File fileToDelete;
    private final FilenameFilter fileFilter;
    private final File backupRoot;

    DeleteOp(File toDelete, FilenameFilter fileFilter) {
        this.fileToDelete = toDelete;
        this.fileFilter = fileFilter;
        this.backupRoot = new File(toDelete.getParentFile(), BACKUP_FOLDER);
    }

    public void execute() throws IOException {
        try {
            this.prepare();
            boolean commitResult = this.commit();
            if (!commitResult) {
                throw PatchLogger.ROOT_LOGGER.failedToDeleteBackup();
            }
        }
        catch (PrepareException pe) {
            this.rollback();
            throw PatchLogger.ROOT_LOGGER.failedToDelete(pe.getPath());
        }
    }

    public static void execute(Collection<DeleteOp> deleteOps) throws IOException {
        try {
            deleteOps.forEach(DeleteOp::prepare);
            boolean commitResult = true;
            for (DeleteOp op : deleteOps) {
                commitResult &= op.commit();
            }
            if (!commitResult) {
                throw PatchLogger.ROOT_LOGGER.failedToDeleteBackup();
            }
        }
        catch (PrepareException pe) {
            deleteOps.forEach(DeleteOp::rollback);
            throw PatchLogger.ROOT_LOGGER.failedToDelete(pe.getPath());
        }
    }

    private void prepare() throws PrepareException {
        this.backupRoot.mkdir();
        this.moveToBackup(this.fileToDelete, this.backupRoot, this.fileFilter);
    }

    private void moveToBackup(File file, File bkp, FilenameFilter fileFilter) throws PrepareException {
        if (!fileFilter.accept(file.getParentFile(), file.getName())) {
            return;
        }
        if (file.isDirectory()) {
            boolean deleted;
            File backupFolder = this.createBackupFolder(file, bkp);
            for (File child : file.listFiles(fileFilter)) {
                this.moveToBackup(child, backupFolder, fileFilter);
            }
            if (DeleteOp.isEmptyFolder(file) && !(deleted = file.delete())) {
                throw new PrepareException(file);
            }
        } else {
            File dest = new File(bkp, file.getName());
            boolean moved = file.renameTo(dest);
            if (!moved) {
                throw new PrepareException(file);
            }
        }
    }

    private File createBackupFolder(File file, File bkp) throws PrepareException {
        File backupFolder = new File(bkp, file.getName());
        if (backupFolder.exists() || !backupFolder.mkdir()) {
            throw new PrepareException(file);
        }
        return backupFolder;
    }

    private static boolean isEmptyFolder(File file) {
        return file.list() != null && file.list().length == 0;
    }

    private boolean commit() {
        File deleteRoot = new File(this.backupRoot, this.fileToDelete.getName());
        boolean commitResult = true;
        if (deleteRoot.exists()) {
            commitResult = this.doDelete(deleteRoot);
        }
        if (DeleteOp.isEmptyFolder(this.backupRoot)) {
            commitResult &= this.backupRoot.delete();
        }
        return commitResult;
    }

    private boolean doDelete(File file) {
        boolean result = true;
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                result &= this.doDelete(child);
            }
        }
        if (!file.delete()) {
            PatchLogger.ROOT_LOGGER.cannotDeleteFile(file.getAbsolutePath());
            result = false;
        }
        return result;
    }

    private void rollback() {
        try {
            if (!this.backupRoot.exists()) {
                return;
            }
            File source = new File(this.backupRoot, this.fileToDelete.getName());
            DeleteOp.doRollback(source, this.fileToDelete);
            if (DeleteOp.isEmptyFolder(this.backupRoot)) {
                this.backupRoot.delete();
            }
        }
        catch (RollbackException e) {
            PatchLogger.ROOT_LOGGER.deleteRollbackError(e.getPath(), e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void doRollback(File source, File destination) throws RollbackException {
        if (source.isDirectory()) {
            if (!destination.exists()) {
                destination.mkdir();
            } else if (!destination.isDirectory()) {
                throw new RollbackException(source, "file with the same name exists");
            }
            for (File child : source.listFiles()) {
                DeleteOp.doRollback(child, new File(destination, child.getName()));
            }
            if (!DeleteOp.isEmptyFolder(source)) throw new RollbackException(source, "directory has unexpected files");
            if (source.delete()) return;
            throw new RollbackException(source, "unable to delete folder");
        }
        if (destination.exists()) {
            throw new RollbackException(source, "file with the same name already exists");
        }
        if (source.renameTo(destination)) return;
        throw new RollbackException(source, "unable to move file");
    }

    private static class RollbackException
    extends Exception {
        private String path;

        public RollbackException(File source, String msg) {
            super(msg);
            this.path = source.getAbsolutePath();
        }

        public String getPath() {
            return this.path;
        }
    }

    private static class PrepareException
    extends RuntimeException {
        private final String path;

        public PrepareException(File file) {
            this.path = file.getAbsolutePath();
        }

        public String getPath() {
            return this.path;
        }
    }
}

