/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol.mgmt;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.logging.ProtocolLogger;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.FlushableDataOutputImpl;
import org.jboss.as.protocol.mgmt.ManagementMessageHandler;
import org.jboss.as.protocol.mgmt.ManagementPongHeader;
import org.jboss.as.protocol.mgmt.ManagementProtocolHeader;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remoting3.MessageOutputStream;

public final class ManagementChannelReceiver
implements Channel.Receiver {
    private final ManagementMessageHandler handler;
    private volatile long lastMessageTime;

    public static ManagementChannelReceiver createDelegating(ManagementMessageHandler handler) {
        assert (handler != null);
        return new ManagementChannelReceiver(handler);
    }

    private ManagementChannelReceiver(ManagementMessageHandler handler) {
        this.handler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Channel channel, MessageInputStream message) {
        try {
            ProtocolLogger.ROOT_LOGGER.tracef("%s handling incoming data", this);
            this.lastMessageTime = System.currentTimeMillis();
            DataInputStream input = new DataInputStream((InputStream)message);
            ManagementProtocolHeader header = ManagementProtocolHeader.parse(input);
            byte type = header.getType();
            try {
                if (type == 5) {
                    ProtocolLogger.ROOT_LOGGER.tracef("Received ping on %s", this);
                    ManagementChannelReceiver.handlePing(channel, header);
                } else if (type == 6) {
                    ProtocolLogger.ROOT_LOGGER.tracef("Received pong on %s", this);
                } else if (type == 4) {
                    ProtocolLogger.ROOT_LOGGER.tracef("Received bye bye on %s, ignoring", this);
                } else {
                    this.handler.handleMessage(channel, input, header);
                }
            }
            finally {
                try {
                    while (message.read() != -1) {
                    }
                }
                catch (IOException iOException) {}
            }
            message.close();
        }
        catch (IOException e) {
            this.handleError(channel, e);
        }
        catch (Exception e) {
            this.handleError(channel, new IOException(e));
        }
        finally {
            StreamUtils.safeClose((Closeable)message);
            ProtocolLogger.ROOT_LOGGER.tracef("%s done handling incoming data", this);
        }
        channel.receiveMessage((Channel.Receiver)this);
    }

    public long getLastMessageTime() {
        return this.lastMessageTime;
    }

    public void handleError(Channel channel, IOException error) {
        ProtocolLogger.ROOT_LOGGER.tracef(error, "%s error handling incoming data", this);
        try {
            channel.close();
        }
        catch (IOException e) {
            ProtocolLogger.ROOT_LOGGER.errorClosingChannel(e.getMessage());
        }
    }

    public void handleEnd(Channel channel) {
        try {
            channel.close();
        }
        catch (IOException e) {
            ProtocolLogger.ROOT_LOGGER.errorClosingChannel(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handlePing(Channel channel, ManagementProtocolHeader header) throws IOException {
        ManagementPongHeader response = new ManagementPongHeader(header.getVersion());
        MessageOutputStream output = channel.writeMessage();
        try {
            ManagementChannelReceiver.writeHeader(response, (OutputStream)output);
            output.close();
        }
        finally {
            StreamUtils.safeClose((Closeable)output);
        }
    }

    private static void writeHeader(ManagementProtocolHeader header, OutputStream os) throws IOException {
        FlushableDataOutput output = FlushableDataOutputImpl.create(os);
        header.write(output);
    }
}

