/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.selfcontained;

import java.io.File;
import java.io.IOException;
import org.jboss.as.selfcontained.SelfContainedContentService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceActivatorContext;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

public class SelfContainedContentServiceActivator
implements ServiceActivator {
    private final File content;

    public SelfContainedContentServiceActivator(File content) {
        this.content = content;
    }

    public void activate(ServiceActivatorContext serviceActivatorContext) throws ServiceRegistryException {
        VirtualFile mountPoint = VFS.getRootVirtualFile().getChild("ROOT.war");
        try {
            VFS.mountReal((File)this.content, (VirtualFile)mountPoint);
            SelfContainedContentService service = new SelfContainedContentService(mountPoint);
            serviceActivatorContext.getServiceTarget().addService(SelfContainedContentService.NAME, (Service)service).install();
        }
        catch (IOException e) {
            throw new ServiceRegistryException((Throwable)e);
        }
    }
}

