/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.dmr.ModelNode;

public abstract class AbstractDeploymentUploadHandler
implements OperationStepHandler {
    private static final Set<Action.ActionEffect> ACTION_EFFECT_SET = EnumSet.of(Action.ActionEffect.WRITE_RUNTIME);
    private final ContentRepository contentRepository;
    protected final AttributeDefinition attribute;

    protected AbstractDeploymentUploadHandler(ContentRepository contentRepository, AttributeDefinition attribute) {
        this.contentRepository = contentRepository;
        this.attribute = attribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        try {
            this.attribute.validateOperation(operation);
            AuthorizationResult authorizationResult = context.authorize(operation, ACTION_EFFECT_SET);
            authorizationResult.failIfDenied(operation, context.getCurrentAddress());
            InputStream is = this.getContentInputStream(context, operation);
            try {
                byte[] hash = this.contentRepository.addContent(is);
                context.getResult().set(hash);
            }
            finally {
                AbstractDeploymentUploadHandler.safeClose(is);
            }
        }
        catch (IOException e) {
            throw ServerLogger.ROOT_LOGGER.caughtIOExceptionUploadingContent(e);
        }
    }

    protected abstract InputStream getContentInputStream(OperationContext var1, ModelNode var2) throws IOException, OperationFailedException;

    private static void safeClose(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception e) {
                ServerLogger.ROOT_LOGGER.caughtExceptionClosingContentInputStream(e);
            }
        }
    }
}

