/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.domain.management.access.RbacSanityCheckOperation;
import org.jboss.as.remoting.management.ManagementRemotingServices;
import org.jboss.as.server.mgmt.HttpManagementResourceDefinition;
import org.jboss.dmr.ModelNode;

public class HttpManagementRemoveHandler
extends ReloadRequiredRemoveStepHandler {
    public static final HttpManagementRemoveHandler INSTANCE = new HttpManagementRemoveHandler();

    private HttpManagementRemoveHandler() {
        super(new RuntimeCapability[]{HttpManagementResourceDefinition.HTTP_MANAGEMENT_CAPABILITY});
    }

    protected void performRemove(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        RbacSanityCheckOperation.addOperation((OperationContext)context);
        PathAddress nativeAddress = context.getCurrentAddress().getParent().append(new PathElement[]{PathElement.pathElement((String)"management-interface", (String)"native-interface")});
        context.addStep((opContext, op) -> ManagementRemotingServices.isManagementResourceRemoveable((OperationContext)opContext, (PathAddress)nativeAddress), OperationContext.Stage.MODEL, false);
        super.performRemove(context, operation, model);
    }

    protected boolean requiresRuntime(OperationContext context) {
        return context.getProcessType() != ProcessType.EMBEDDED_SERVER || context.getRunningMode() != RunningMode.ADMIN_ONLY;
    }
}

