/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.util.Collections;
import java.util.EnumSet;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.server.DeployerChainAddHandler;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;

public abstract class AbstractDeploymentChainStep
implements OperationStepHandler {
    private static DeploymentProcessorTarget TARGET = new DeploymentProcessorTarget(){

        @Override
        public void addDeploymentProcessor(String subsystemName, Phase phase, int priority, DeploymentUnitProcessor processor) {
            DeployerChainAddHandler.addDeploymentProcessor(subsystemName, phase, priority, processor);
        }

        @Override
        public void addDeploymentProcessor(Phase phase, int priority, DeploymentUnitProcessor processor) {
            this.addDeploymentProcessor("", phase, priority, processor);
        }
    };

    public final void execute(OperationContext context, ModelNode operation) {
        if (context.isBooting()) {
            this.execute(TARGET);
        } else {
            EnumSet flags;
            ImmutableManagementResourceRegistration mrr = context.getResourceRegistration();
            OperationEntry oe = mrr.getOperationEntry(PathAddress.EMPTY_ADDRESS, operation.get("operation").asString());
            EnumSet enumSet = flags = oe == null ? Collections.emptySet() : oe.getOperationDefinition().getFlags();
            if (flags.contains(OperationEntry.Flag.RESTART_JVM)) {
                context.restartRequired();
                context.completeStep((ctx, op) -> ctx.revertRestartRequired());
            } else if (flags.contains(OperationEntry.Flag.RESTART_ALL_SERVICES)) {
                context.reloadRequired();
                context.completeStep(OperationContext.RollbackHandler.REVERT_RELOAD_REQUIRED_ROLLBACK_HANDLER);
            } else {
                throw new IllegalStateException();
            }
        }
    }

    protected abstract void execute(DeploymentProcessorTarget var1);
}

