/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.util.List;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

public class DeploymentCompleteServiceProcessor
implements DeploymentUnitProcessor {
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"deploymentCompleteService"});

    public static ServiceName serviceName(ServiceName deploymentUnitServiceName) {
        return deploymentUnitServiceName.append(SERVICE_NAME);
    }

    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (deploymentUnit.getParent() == null) {
            for (DeploymentUnit subDeployment : deploymentUnit.getAttachmentList(Attachments.SUB_DEPLOYMENTS)) {
                deploymentUnit.addToAttachmentList(Attachments.DEPLOYMENT_COMPLETE_SERVICES, DeploymentCompleteServiceProcessor.serviceName(subDeployment.getServiceName()));
            }
        }
        ServiceBuilder sb = phaseContext.getServiceTarget().addService(DeploymentCompleteServiceProcessor.serviceName(deploymentUnit.getServiceName()), Service.NULL);
        List<ServiceName> deploymentCompleteServices = deploymentUnit.getAttachmentList(Attachments.DEPLOYMENT_COMPLETE_SERVICES);
        if (deploymentCompleteServices != null) {
            for (ServiceName deploymentCompleteService : deploymentCompleteServices) {
                sb.addDependency(deploymentCompleteService);
            }
        }
        sb.install();
    }

    @Override
    public void undeploy(DeploymentUnit deploymentUnit) {
        deploymentUnit.removeAttachment(Attachments.DEPLOYMENT_COMPLETE_SERVICES);
    }
}

