/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.security;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.online.CliException;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.OperationException;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;

public final class AddMappingModule
implements OnlineCommand,
OfflineCommand {
    private final String securityDomainName;
    private final String name;
    private final String code;
    private final String type;
    private final String module;
    private final Map<String, String> moduleOptions;
    private final boolean replaceExisting;

    private AddMappingModule(Builder builder) {
        this.securityDomainName = builder.securityDomainName;
        this.name = builder.name;
        this.code = builder.code;
        this.type = builder.type;
        this.module = builder.module;
        this.moduleOptions = builder.moduleOptions;
        this.replaceExisting = builder.replaceExisting;
    }

    public void apply(OnlineCommandContext ctx) throws CliException, CommandFailedException, IOException, TimeoutException, InterruptedException {
        Operations ops = new Operations(ctx.client);
        Address mappingClassicAddress = Address.subsystem((String)"security").and("security-domain", this.securityDomainName).and("mapping", "classic");
        try {
            boolean exists = ops.exists(mappingClassicAddress);
            if (!exists) {
                ops.add(mappingClassicAddress);
            }
        }
        catch (OperationException e) {
            throw new IOException("Failed to access or create mapping=classic in security domain " + this.securityDomainName, e);
        }
        Address mappingModuleAddress = mappingClassicAddress.and("mapping-module", this.name);
        if (this.replaceExisting) {
            try {
                ops.removeIfExists(mappingModuleAddress);
            }
            catch (OperationException e) {
                throw new IOException("Failed to remove existing mapping module " + this.name + " in security domain " + this.securityDomainName, e);
            }
        }
        ops.add(mappingModuleAddress, Values.empty().andOptional("code", this.code).andOptional("type", this.type).andOptional("module", this.module).andObjectOptional("module-options", Values.fromMap(this.moduleOptions)));
    }

    public void apply(OfflineCommandContext ctx) throws CommandFailedException, IOException {
        ctx.client.apply(new OfflineCommand[]{GroovyXmlTransform.of(AddMappingModule.class).subtree("securitySubsystem", Subtree.subsystem("security")).parameter("atrSecurityDomainName", this.securityDomainName).parameter("atrName", this.name).parameter("atrCode", this.code).parameter("atrType", this.type).parameter("atrModule", this.module).parameter("atrModuleOptions", this.moduleOptions).parameter("atrReplaceExisting", this.replaceExisting).build()});
    }

    public static final class Builder {
        private String securityDomainName;
        private String name;
        private String code;
        private String type;
        private String module;
        private final Map<String, String> moduleOptions = new LinkedHashMap<String, String>();
        private boolean replaceExisting;

        public Builder(String code) {
            this(code, code);
        }

        public Builder(String code, String name) {
            if (code == null) {
                throw new IllegalArgumentException("Code of the mapping module must be specified as non null value");
            }
            if (name == null) {
                throw new IllegalArgumentException("Name of the mapping module must be specified as non null value");
            }
            if (code.isEmpty()) {
                throw new IllegalArgumentException("Code of the mapping module must not be empty value");
            }
            if (name.isEmpty()) {
                throw new IllegalArgumentException("Name of the mapping module must not be empty value");
            }
            this.code = code;
            this.name = name;
        }

        public Builder securityDomainName(String securityDomainName) {
            this.securityDomainName = securityDomainName;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder module(String module) {
            this.module = module;
            return this;
        }

        public Builder addModuleOption(String name, String value) {
            this.moduleOptions.put(name, value);
            return this;
        }

        public Builder replaceExisting() {
            this.replaceExisting = true;
            return this;
        }

        public AddMappingModule build() {
            if (this.securityDomainName == null) {
                throw new IllegalArgumentException("Name of the security-domain must be specified as non null value");
            }
            if (this.securityDomainName.isEmpty()) {
                throw new IllegalArgumentException("Name of the security-domain must not be empty value");
            }
            if (this.type == null) {
                throw new IllegalArgumentException("Type of the security-domain must be specified as non null value");
            }
            return new AddMappingModule(this);
        }
    }
}

