/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.security;

import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;

public final class RemoveMappingModule
implements OnlineCommand,
OfflineCommand {
    private final String securityDomainName;
    private final String mappingModuleName;

    public RemoveMappingModule(String securityDomainName, String mappingModuleName) {
        if (securityDomainName == null) {
            throw new IllegalArgumentException("Name of the security-domain must be specified as non null value");
        }
        if (securityDomainName.isEmpty()) {
            throw new IllegalArgumentException("Name of the security-domain must not be empty value");
        }
        if (mappingModuleName == null) {
            throw new IllegalArgumentException("Name of the mapping-module must be specified as non null value");
        }
        if (mappingModuleName.isEmpty()) {
            throw new IllegalArgumentException("Name of the mapping-module must not be empty value");
        }
        this.securityDomainName = securityDomainName;
        this.mappingModuleName = mappingModuleName;
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        Operations ops = new Operations(ctx.client);
        ops.remove(Address.subsystem((String)"security").and("security-domain", this.securityDomainName).and("mapping", "classic").and("mapping-module", this.mappingModuleName));
    }

    public void apply(OfflineCommandContext ctx) throws Exception {
        ctx.client.apply(new OfflineCommand[]{GroovyXmlTransform.of(RemoveMappingModule.class).subtree("securitySubsystem", Subtree.subsystem("security")).parameter("atrSecurityDomainName", this.securityDomainName).parameter("atrMappingModuleName", this.mappingModuleName).build()});
    }
}

