/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.deployment;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.wildfly.plugin.deployment.AbstractDeployment;
import org.wildfly.plugin.deployment.PackageType;

abstract class AbstractAppDeployment
extends AbstractDeployment {
    @Parameter(defaultValue="${project.build.directory}/", property="wildfly.deployment.targetDir")
    private File targetDir;
    @Parameter(property="wildfly.deployment.filename")
    private String filename;
    @Parameter(alias="check-packaging", property="wildfly.checkPackaging", defaultValue="true")
    private boolean checkPackaging;
    private PackageType packageType;

    AbstractAppDeployment() {
    }

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        PackageType packageType = this.getPackageType();
        if (this.checkPackaging && packageType.isIgnored()) {
            this.getLog().debug((CharSequence)String.format("Ignoring packaging type %s.", packageType.getPackaging()));
        } else {
            super.doExecute();
        }
    }

    @Override
    protected File file() {
        PackageType packageType = this.getPackageType();
        String filename = this.filename == null ? String.format("%s.%s", this.project.getBuild().getFinalName(), packageType.getFileExtension()) : this.filename;
        return new File(this.targetDir, filename);
    }

    private synchronized PackageType getPackageType() {
        if (this.packageType == null) {
            this.packageType = PackageType.resolve(this.project);
        }
        return this.packageType;
    }
}

