/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.server;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jboss.as.controller.client.ModelControllerClient;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.StandaloneCommandBuilder;
import org.wildfly.plugin.common.DeploymentFailureException;
import org.wildfly.plugin.common.ServerOperations;
import org.wildfly.plugin.deployment.DeployMojo;
import org.wildfly.plugin.deployment.Deployment;
import org.wildfly.plugin.deployment.standalone.StandaloneDeploymentBuilder;
import org.wildfly.plugin.server.AddUser;
import org.wildfly.plugin.server.Archives;
import org.wildfly.plugin.server.ArtifactResolver;
import org.wildfly.plugin.server.ModulesPath;
import org.wildfly.plugin.server.Server;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.RUNTIME)
@Execute(phase=LifecyclePhase.PACKAGE)
public class RunMojo
extends DeployMojo {
    public static final String WILDFLY_DIR = "wildfly-run";
    @Inject
    private ArtifactResolver artifactResolver;
    @Parameter(alias="jboss-home", property="jboss-as.home")
    private String jbossHome;
    @Parameter(property="wildfly.artifact")
    private String artifact;
    @Parameter(defaultValue="org.wildfly", property="wildfly.groupId")
    private String groupId;
    @Parameter(defaultValue="wildfly-dist", property="wildfly.artifactId")
    private String artifactId;
    @Parameter(property="wildfly.classifier")
    private String classifier;
    @Parameter(property="wildfly.packaging", defaultValue="zip")
    private String packaging;
    @Parameter(property="wildfly.version")
    private String version;
    @Parameter(alias="modules-path", property="wildfly.modulesPath")
    private ModulesPath modulesPath;
    @Deprecated
    @Parameter(alias="jvm-args", property="wildfly.jvmArgs")
    private String jvmArgs;
    @Parameter(alias="java-opts", property="wildfly.javaOpts")
    private String[] javaOpts;
    @Parameter(alias="java-home", property="java.home")
    private String javaHome;
    @Parameter(alias="server-config", property="wildfly.serverConfig")
    private String serverConfig;
    @Parameter(alias="properties-file", property="wildfly.propertiesFile")
    private String propertiesFile;
    @Parameter(alias="startup-timeout", defaultValue="60", property="wildfly.startupTimeout")
    private long startupTimeout;
    @Parameter(alias="server-args", property="wildfly.serverArgs")
    private String[] serverArgs;
    @Parameter(alias="add-user", property="wildfly.add-user")
    private AddUser addUser;
    @Parameter
    private Map<String, String> env;

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        File deploymentFile = this.file();
        if (!deploymentFile.exists()) {
            throw new MojoExecutionException(String.format("The deployment '%s' could not be found.", deploymentFile.getAbsolutePath()));
        }
        Path jbossHome = this.extractIfRequired(deploymentFile.getParentFile().toPath());
        if (!Files.isDirectory(jbossHome, new LinkOption[0])) {
            throw new MojoExecutionException(String.format("JBOSS_HOME '%s' is not a valid directory.", jbossHome));
        }
        StandaloneCommandBuilder commandBuilder = (StandaloneCommandBuilder)StandaloneCommandBuilder.of((Path)jbossHome).setJavaHome(this.javaHome).addModuleDirs(this.modulesPath.getModulePaths());
        if (this.javaOpts != null) {
            commandBuilder.setJavaOptions(this.javaOpts);
        } else if (this.jvmArgs != null) {
            commandBuilder.setJavaOptions(this.jvmArgs.split("\\s+"));
        }
        if (this.serverConfig != null) {
            commandBuilder.setServerConfiguration(this.serverConfig);
        }
        if (this.propertiesFile != null) {
            commandBuilder.setPropertiesFile(this.propertiesFile);
        }
        if (this.serverArgs != null) {
            commandBuilder.addServerArguments(this.serverArgs);
        }
        log.info((CharSequence)String.format("JAVA_HOME=%s", commandBuilder.getJavaHome()));
        log.info((CharSequence)String.format("JBOSS_HOME=%s%n", commandBuilder.getWildFlyHome()));
        Server server = null;
        try (ModelControllerClient client = this.createClient();){
            if (this.addUser != null && this.addUser.hasUsers()) {
                log.info((CharSequence)("Adding users: " + this.addUser));
                this.addUser.addUsers(commandBuilder.getWildFlyHome(), commandBuilder.getJavaHome());
            }
            server = Server.create((CommandBuilder)commandBuilder, this.env, client);
            log.info((CharSequence)"Server is starting up. Press CTRL + C to stop the server.");
            server.start(this.startupTimeout);
            server.checkServerState();
            if (server.isRunning()) {
                log.info((CharSequence)String.format("Deploying application '%s'%n", deploymentFile.getName()));
                Deployment deployment = ((StandaloneDeploymentBuilder)((StandaloneDeploymentBuilder)((StandaloneDeploymentBuilder)((StandaloneDeploymentBuilder)new StandaloneDeploymentBuilder(client).setContent(deploymentFile)).setName(this.name)).setRuntimeName(this.runtimeName)).setType(this.getType())).build();
                switch (this.executeDeployment(client, deployment, jbossHome)) {
                    case REQUIRES_RESTART: {
                        client.execute(ServerOperations.createOperation((String)"reload"));
                        break;
                    }
                }
            } else {
                throw new DeploymentFailureException("Cannot deploy to a server that is not running.");
            }
            while (server.isRunning()) {
                TimeUnit.SECONDS.sleep(1L);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("The server failed to start", e);
        }
        finally {
            if (server != null) {
                server.stop();
            }
        }
    }

    private Path extractIfRequired(Path buildDir) throws MojoFailureException, MojoExecutionException {
        if (this.jbossHome != null) {
            return Paths.get(this.jbossHome, new String[0]);
        }
        String artifact = ArtifactResolver.ArtifactNameSplitter.of(this.artifact).setArtifactId(this.artifactId).setClassifier(this.classifier).setGroupId(this.groupId).setPackaging(this.packaging).setVersion(this.version).asString();
        Path result = this.artifactResolver.resolve(this.project, artifact).toPath();
        Path target = buildDir.resolve(WILDFLY_DIR);
        if (Files.exists(target, new LinkOption[0])) {
            try {
                Archives.deleteDirectory(target);
            }
            catch (IOException e) {
                throw new MojoFailureException("Could not delete target directory: " + target, (Throwable)e);
            }
        }
        try {
            Archives.unzip(result, target);
            Iterator<Path> iterator = Files.newDirectoryStream(target).iterator();
            if (iterator.hasNext()) {
                return iterator.next();
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Artifact was not successfully extracted: " + result, (Throwable)e);
        }
        throw new MojoFailureException("Artifact was not successfully extracted: " + result);
    }

    @Override
    public String goal() {
        return "run";
    }
}

