/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.repository;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.jboss.jdf.stacks.client.StacksClient;
import org.jboss.jdf.stacks.model.Runtime;
import org.jboss.jdf.stacks.model.Stacks;
import org.wildfly.plugin.server.VersionComparator;

class Runtimes {
    private static final String WILDFLY_TARGET_VERSION = "14.0.1.Final";
    private final List<Runtime> availableRuntimes;

    private Runtimes() {
        StacksClient client = new StacksClient();
        Stacks stacks = client.getStacks();
        this.availableRuntimes = Collections.synchronizedList(stacks.getAvailableRuntimes());
    }

    static String getLatestFinal(String groupId, String artifactId) {
        if (groupId == null) {
            throw new IllegalArgumentException("groupId cannot be null");
        }
        if (artifactId == null) {
            throw new IllegalArgumentException("artifactId cannot be null");
        }
        NavigableSet<String> versions = Holder.INSTANCE.getVersions(groupId, artifactId);
        for (String version : versions.descendingSet()) {
            String l = version.toLowerCase(Locale.ENGLISH);
            if (!l.endsWith("final") && !l.endsWith("ga")) continue;
            return version;
        }
        return WILDFLY_TARGET_VERSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NavigableSet<String> getVersions(String groupId, String artifactId) {
        TreeSet<String> versions = new TreeSet<String>(new VersionComparator());
        List<Runtime> list = this.availableRuntimes;
        synchronized (list) {
            for (Runtime runtime : this.availableRuntimes) {
                if (!groupId.equalsIgnoreCase(runtime.getGroupId()) || !artifactId.equalsIgnoreCase(runtime.getArtifactId())) continue;
                versions.add(runtime.getVersion());
            }
        }
        return versions;
    }

    private static class Holder {
        static final Runtimes INSTANCE = new Runtimes();

        private Holder() {
        }
    }
}

