/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.cli;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jboss.as.controller.client.ModelControllerClient;

class CLIWrapper
implements AutoCloseable {
    private final Object ctx;
    private final Method handle;
    private final Method handleSafe;
    private final Method terminateSession;
    private final Method bindClient;
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    private final String origConfig;

    public CLIWrapper(Path jbossHome, boolean resolveExpression, ClassLoader loader) throws Exception {
        if (jbossHome != null) {
            Path config = jbossHome.resolve("bin").resolve("jboss-cli.xml");
            this.origConfig = System.getProperty("jboss.cli.config");
            if (Files.exists(config, new LinkOption[0])) {
                System.setProperty("jboss.cli.config", config.toString());
            }
        } else {
            this.origConfig = null;
        }
        Object builder = loader.loadClass("org.jboss.as.cli.impl.CommandContextConfiguration$Builder").newInstance();
        Method setEchoCommand = builder.getClass().getMethod("setEchoCommand", Boolean.TYPE);
        setEchoCommand.invoke(builder, true);
        Method setResolve = builder.getClass().getMethod("setResolveParameterValues", Boolean.TYPE);
        setResolve.invoke(builder, resolveExpression);
        Method setOutput = builder.getClass().getMethod("setConsoleOutput", OutputStream.class);
        setOutput.invoke(builder, this.out);
        Object ctxConfig = builder.getClass().getMethod("build", new Class[0]).invoke(builder, new Object[0]);
        Object factory = loader.loadClass("org.jboss.as.cli.CommandContextFactory").getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
        Class<?> configClass = loader.loadClass("org.jboss.as.cli.impl.CommandContextConfiguration");
        this.ctx = factory.getClass().getMethod("newCommandContext", configClass).invoke(factory, ctxConfig);
        this.handle = this.ctx.getClass().getMethod("handle", String.class);
        this.handleSafe = this.ctx.getClass().getMethod("handleSafe", String.class);
        this.terminateSession = this.ctx.getClass().getMethod("terminateSession", new Class[0]);
        this.bindClient = this.ctx.getClass().getMethod("bindClient", ModelControllerClient.class);
    }

    public void bindClient(ModelControllerClient client) throws Exception {
        this.bindClient.invoke(this.ctx, client);
    }

    public void handle(String command) throws Exception {
        this.handle.invoke(this.ctx, command);
    }

    public void handleSafe(String command) throws Exception {
        this.handleSafe.invoke(this.ctx, command);
    }

    public String getOutput() {
        return this.out.toString();
    }

    @Override
    public void close() throws Exception {
        try {
            this.terminateSession.invoke(this.ctx, new Object[0]);
        }
        finally {
            if (this.origConfig != null) {
                System.setProperty("jboss.cli.config", this.origConfig);
            }
        }
    }
}

