/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.permission;

import org.wildfly.common.Assert;
import org.wildfly.security.permission.AbstractNameSetOnlyPermission;
import org.wildfly.security.permission.AbstractPermission;
import org.wildfly.security.permission.AbstractPermissionCollection;
import org.wildfly.security.permission.IntNameSetPermissionCollection;
import org.wildfly.security.permission.LongNameSetPermissionCollection;
import org.wildfly.security.util.StringEnumeration;

public abstract class NameSetPermissionCollection
extends AbstractPermissionCollection {
    private static final long serialVersionUID = -9191397492173027470L;
    private final StringEnumeration nameEnumeration;

    public static AbstractPermissionCollection newInstance(AbstractNameSetOnlyPermission<?> sourcePermission) {
        return NameSetPermissionCollection.newInstance(sourcePermission, sourcePermission.getNameEnumeration());
    }

    public static AbstractPermissionCollection newInstance(AbstractPermission<?> sourcePermission, StringEnumeration nameEnumeration) {
        Assert.checkNotNullParam((String)"sourcePermission", sourcePermission);
        Assert.checkNotNullParam((String)"nameEnumeration", (Object)nameEnumeration);
        int size = nameEnumeration.size();
        if (size <= 32) {
            return new IntNameSetPermissionCollection(sourcePermission, nameEnumeration);
        }
        if (size <= 64) {
            return new LongNameSetPermissionCollection(sourcePermission, nameEnumeration);
        }
        throw Assert.unsupported();
    }

    NameSetPermissionCollection(AbstractPermission<?> sourcePermission, StringEnumeration nameEnumeration) {
        super(sourcePermission);
        this.nameEnumeration = nameEnumeration;
    }

    StringEnumeration getNameEnumeration() {
        return this.nameEnumeration;
    }
}

