/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.asn1;

import org.wildfly.security.asn1.ASN1Decoder;
import org.wildfly.security.asn1.ASN1Exception;
import org.wildfly.security.util._private.Arrays2;

public class ASN1 {
    public static final int INTEGER_TYPE = 2;
    public static final int BIT_STRING_TYPE = 3;
    public static final int OCTET_STRING_TYPE = 4;
    public static final int NULL_TYPE = 5;
    public static final int OBJECT_IDENTIFIER_TYPE = 6;
    public static final int PRINTABLE_STRING_TYPE = 19;
    public static final int IA5_STRING_TYPE = 22;
    public static final int SEQUENCE_TYPE = 48;
    public static final int SET_TYPE = 49;
    public static final int CONSTRUCTED_MASK = 32;
    public static final int CONTEXT_SPECIFIC_MASK = 128;
    public static final int CLASS_MASK = 192;
    public static final int TAG_NUMBER_MASK = 31;
    public static final String OID_SHA1_WITH_RSA = "1.2.840.113549.1.1.5";
    public static final String OID_SHA1_WITH_DSA = "1.2.840.10040.4.3";
    public static final String OID_SHA1_WITH_ECDSA = "1.2.840.10045.4.1";

    public static String formatAsn1(ASN1Decoder decoder) {
        StringBuilder builder = new StringBuilder();
        ASN1.formatAsn1(decoder, builder);
        return builder.toString();
    }

    public static void formatAsn1(ASN1Decoder decoder, StringBuilder builder) {
        block11: while (decoder.hasNextElement()) {
            int type = decoder.peekType();
            switch (type) {
                case 2: {
                    decoder.decodeOctetString();
                    builder.append("[int]");
                    continue block11;
                }
                case 3: {
                    builder.append("[bits:").append(decoder.decodeBitStringAsString()).append(']');
                    continue block11;
                }
                case 4: {
                    builder.append("[octets:").append(Arrays2.toString(decoder.decodeOctetString())).append(']');
                    continue block11;
                }
                case 5: {
                    builder.append("[null]");
                    decoder.decodeNull();
                    continue block11;
                }
                case 6: {
                    builder.append("[oid:").append(decoder.decodeObjectIdentifier()).append(']');
                    continue block11;
                }
                case 22: {
                    builder.append("[ia5:").append(decoder.decodeIA5String()).append(']');
                    continue block11;
                }
                case 48: {
                    builder.append("[sequence:");
                    decoder.startSequence();
                    ASN1.formatAsn1(decoder, builder);
                    decoder.endSequence();
                    builder.append(']');
                    continue block11;
                }
                case 49: {
                    builder.append("[set:");
                    decoder.startSet();
                    ASN1.formatAsn1(decoder, builder);
                    decoder.endSet();
                    builder.append(']');
                    continue block11;
                }
                case 19: {
                    builder.append("[printable:").append(decoder.decodePrintableString()).append(']');
                    continue block11;
                }
            }
            throw new IllegalArgumentException("Unknown tag type: " + type);
        }
    }

    static void validatePrintableByte(int b) throws ASN1Exception {
        switch (b) {
            case 32: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 58: 
            case 61: 
            case 63: {
                return;
            }
        }
        if (65 <= b && b <= 90 || 97 <= b && b <= 122 || 48 <= b && b <= 57) {
            return;
        }
        throw new ASN1Exception("Unexpected character byte for printable string");
    }
}

