/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth;

import java.net.URI;
import org.wildfly.security.auth.MatchNoUserRule;
import org.wildfly.security.auth.MatchRule;
import org.wildfly.security.util.URIUtil;

class MatchUserRule
extends MatchRule {
    private final String userSpec;

    MatchUserRule(MatchRule parent, String userSpec) {
        super(parent.without(MatchNoUserRule.class));
        this.userSpec = userSpec;
    }

    @Override
    public boolean matches(URI uri) {
        String userInfo = URIUtil.getUserFromURI(uri);
        return userInfo != null && userInfo.equals(this.userSpec) && super.matches(uri);
    }

    @Override
    MatchRule reparent(MatchRule newParent) {
        return new MatchUserRule(newParent, this.userSpec);
    }

    @Override
    public String getMatchUser() {
        return this.userSpec;
    }

    @Override
    public boolean isUserMatched() {
        return true;
    }

    @Override
    boolean halfEqual(MatchRule other) {
        return this.userSpec.equals(other.getMatchUser());
    }

    @Override
    public int hashCode() {
        return 3323 * this.userSpec.hashCode() + this.parentHashCode();
    }

    @Override
    StringBuilder asString(StringBuilder b) {
        return this.parentAsString(b).append("user=").append(this.userSpec).append(',');
    }
}

