/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.login;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.spec.InvalidKeySpecException;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.security.auth.AuthenticationConfiguration;
import org.wildfly.security.auth.AuthenticationContext;
import org.wildfly.security.auth.MatchRule;
import org.wildfly.security.auth.callback.AuthenticationCompleteCallback;
import org.wildfly.security.auth.callback.CallbackUtil;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.callback.CredentialParameterCallback;
import org.wildfly.security.auth.callback.FastUnsupportedCallbackException;
import org.wildfly.security.auth.callback.PeerPrincipalCallback;
import org.wildfly.security.auth.callback.SecurityLayerDisposedCallback;
import org.wildfly.security.auth.callback.SocketAddressCallback;
import org.wildfly.security.auth.login.SecurityDomain;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.spi.RealmIdentity;
import org.wildfly.security.auth.spi.RealmUnavailableException;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.TwoWayPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslServer;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslServerFactory;

class SecurityDomainSaslServerFactory
extends AbstractDelegatingSaslServerFactory {
    private final SecurityDomain domain;

    SecurityDomainSaslServerFactory(SaslServerFactory delegateFactory, SecurityDomain domain) {
        super(delegateFactory);
        this.domain = domain;
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        final DomainCallbackHandler callbackHandler = new DomainCallbackHandler();
        SaslServer saslServer = this.delegate.createSaslServer(mechanism, protocol, serverName, props, callbackHandler);
        if (saslServer == null) {
            return null;
        }
        return new AbstractDelegatingSaslServer(saslServer){

            @Override
            public Object getNegotiatedProperty(String propName) {
                switch (propName) {
                    case "org.wildfly.auth-context": {
                        return callbackHandler.context;
                    }
                    case "org.wildfly.realm-identity": {
                        return callbackHandler.identity;
                    }
                }
                return this.delegate.getNegotiatedProperty(propName);
            }
        };
    }

    class DomainCallbackHandler
    implements CallbackHandler {
        RealmIdentity identity;
        AuthenticationContext context;

        DomainCallbackHandler() {
        }

        public RealmIdentity getIdentity() {
            return this.identity;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            try {
                this.innerHandle(callbacks);
            }
            catch (RealmUnavailableException e) {
                throw new IOException(e);
            }
        }

        private void innerHandle(Callback[] callbacks) throws IOException, UnsupportedCallbackException, RealmUnavailableException {
            block2: for (Callback callback : callbacks) {
                RealmIdentity realmIdentity;
                if (callback instanceof NameCallback) {
                    if (this.identity != null) {
                        throw new SaslException("Mechanism supplied multiple login names");
                    }
                    String name = ((NameCallback)callback).getName();
                    realmIdentity = SecurityDomainSaslServerFactory.this.domain.mapName(name);
                    if (realmIdentity == null) {
                        throw new SaslException("Unknown user name");
                    }
                    this.identity = realmIdentity;
                    continue;
                }
                if (callback instanceof PeerPrincipalCallback) {
                    if (this.identity != null) {
                        throw new SaslException("Mechanism supplied multiple login names");
                    }
                    Principal principal = ((PeerPrincipalCallback)callback).getPrincipal();
                    realmIdentity = SecurityDomainSaslServerFactory.this.domain.mapName(principal.getName());
                    if (realmIdentity == null) {
                        throw new SaslException("Unknown user name");
                    }
                    this.identity = realmIdentity;
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    ClearPasswordSpec clearPasswordSpec;
                    PasswordCallback passwordCallback = (PasswordCallback)callback;
                    if (this.identity == null) {
                        throw new SaslException("No user identity loaded for credential verification");
                    }
                    TwoWayPassword credential = this.identity.getCredential(TwoWayPassword.class);
                    if (credential == null) {
                        throw new FastUnsupportedCallbackException(callback);
                    }
                    try {
                        PasswordFactory passwordFactory = PasswordFactory.getInstance(credential.getAlgorithm());
                        clearPasswordSpec = passwordFactory.getKeySpec(credential, ClearPasswordSpec.class);
                    }
                    catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                        throw new FastUnsupportedCallbackException(callback);
                    }
                    passwordCallback.setPassword(clearPasswordSpec.getEncodedPassword());
                    continue;
                }
                if (callback instanceof CredentialCallback) {
                    CredentialCallback credentialCallback = (CredentialCallback)callback;
                    if (this.identity == null) {
                        throw new SaslException("No user identity loaded for credential verification");
                    }
                    for (Class clazz : credentialCallback.getAllowedTypes()) {
                        Object credential;
                        if (!this.identity.getCredentialSupport(clazz).mayBeObtainable() || (credential = this.identity.getCredential(clazz)) == null) continue;
                        credentialCallback.setCredential(credential);
                        continue block2;
                    }
                    continue;
                }
                if (callback instanceof CredentialParameterCallback) continue;
                if (callback instanceof AuthenticationCompleteCallback) {
                    if (this.identity != null) {
                        AuthenticationConfiguration conf = AuthenticationConfiguration.EMPTY.usePrincipal((NamePrincipal)this.identity.getPrincipal());
                        MatchRule matchRule = MatchRule.ALL.matchLocalSecurityDomain("TODO: security domain name");
                        this.context = AuthenticationContext.empty().with(matchRule, conf);
                    }
                    this.identity = null;
                    continue;
                }
                if (callback instanceof SecurityLayerDisposedCallback) {
                    this.context = null;
                    continue;
                }
                if (callback instanceof SocketAddressCallback) {
                    SocketAddressCallback socketAddressCallback = (SocketAddressCallback)callback;
                    if (socketAddressCallback.getKind() != SocketAddressCallback.Kind.PEER) continue;
                }
                CallbackUtil.unsupported(callback);
            }
        }
    }
}

