/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.provider;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.spi.AuthenticatedRealmIdentity;
import org.wildfly.security.auth.spi.CredentialSupport;
import org.wildfly.security.auth.spi.RealmIdentity;
import org.wildfly.security.auth.spi.RealmUnavailableException;
import org.wildfly.security.auth.spi.SecurityRealm;
import org.wildfly.security.auth.util.NameRewriter;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;

public class SimpleMapBackedSecurityRealm
implements SecurityRealm {
    private final NameRewriter[] rewriters;
    private volatile Map<NamePrincipal, Password> map = Collections.emptyMap();

    public SimpleMapBackedSecurityRealm(NameRewriter ... rewriters) {
        this.rewriters = (NameRewriter[])rewriters.clone();
    }

    public void setPasswordMap(Map<NamePrincipal, Password> passwordMap) {
        this.map = passwordMap;
    }

    @Override
    public RealmIdentity createRealmIdentity(String name) {
        for (NameRewriter rewriter : this.rewriters) {
            name = rewriter.rewriteName(name);
        }
        return this.createRealmIdentity(new NamePrincipal(name));
    }

    @Override
    public RealmIdentity createRealmIdentity(Principal principal) {
        if (!(principal instanceof NamePrincipal)) {
            throw new IllegalArgumentException("Invalid Principal type");
        }
        return new SimpleMapRealmIdentity(principal);
    }

    private boolean checkType(Set<Class<?>> supportedTypes, HashSet<Class<?>> checked, Class<?> actualType) {
        return actualType != null && checked.add(actualType) && (supportedTypes.contains(actualType) || this.checkType(supportedTypes, checked, actualType.getSuperclass()) || this.checkInterfaces(supportedTypes, checked, actualType));
    }

    private boolean checkInterfaces(Set<Class<?>> supportedTypes, HashSet<Class<?>> checked, Class<?> actualType) {
        for (Class<?> clazz : actualType.getInterfaces()) {
            if (!this.checkType(supportedTypes, checked, clazz)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CredentialSupport getCredentialSupport(Class<?> credentialType) {
        return Password.class.isAssignableFrom(credentialType) ? CredentialSupport.UNKNOWN : CredentialSupport.UNSUPPORTED;
    }

    private class SimpleMapRealmIdentity
    implements RealmIdentity {
        private final Principal principal;

        SimpleMapRealmIdentity(Principal principal) {
            this.principal = principal;
        }

        @Override
        public Principal getPrincipal() {
            return this.principal;
        }

        @Override
        public CredentialSupport getCredentialSupport(Class<?> credentialType) {
            Password password = (Password)SimpleMapBackedSecurityRealm.this.map.get(this.principal);
            return credentialType.isInstance(password) ? CredentialSupport.FULLY_SUPPORTED : CredentialSupport.UNSUPPORTED;
        }

        @Override
        public <C> C getCredential(Class<C> credentialType) {
            Password password = (Password)SimpleMapBackedSecurityRealm.this.map.get(this.principal);
            return credentialType.isInstance(password) ? (C)credentialType.cast(password) : null;
        }

        @Override
        public void dispose() {
        }

        @Override
        public AuthenticatedRealmIdentity getAuthenticatedRealmIdentity() {
            return new AuthenticatedRealmIdentity(){

                @Override
                public Principal getPrincipal() {
                    return SimpleMapRealmIdentity.this.principal;
                }

                @Override
                public void dispose() {
                }
            };
        }

        @Override
        public boolean verifyCredential(Object credential) throws RealmUnavailableException {
            if (credential instanceof char[]) {
                try {
                    Password password = (Password)SimpleMapBackedSecurityRealm.this.map.get(this.principal);
                    return PasswordFactory.getInstance(password.getAlgorithm()).verify(password, (char[])credential);
                }
                catch (InvalidKeyException | NoSuchAlgorithmException e) {
                    throw new RealmUnavailableException(e);
                }
            }
            return false;
        }
    }
}

