/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.keystore;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.keystore.EnablingPasswordEntry;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.interfaces.DigestPassword;
import org.wildfly.security.password.spec.DigestPasswordSpec;
import org.wildfly.security.util.ByteIterator;
import org.wildfly.security.util.CodePointIterator;

public class PropertiesKeyStoreSpi
extends KeyStoreSpi {
    static final char[] ESCAPE_ARRAY = new char[]{'=', '\\'};
    static final String COMMENT_PREFIX = "#";
    static final String REALM_COMMENT_PREFIX = "$REALM_NAME=";
    static final String REALM_COMMENT_SUFFIX = "$";
    static final String REALM_COMMENT_COMMENT = " This line is used by the add-user utility to identify the realm name already used in this file.";
    static final Pattern PROPERTY_PATTERN = Pattern.compile("#??([^#]*)=(([\\da-f]{2})+)$");
    private final AtomicReference<HashMap<String, EnablingPasswordEntry>> pwRef = new AtomicReference();
    private final AtomicReference<String> realmName = new AtomicReference();
    private List<String> fileContents = new ArrayList<String>();
    private final PasswordFactory passwordFactory;

    public PropertiesKeyStoreSpi() {
        try {
            this.passwordFactory = PasswordFactory.getInstance("digest-md5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        HashMap<String, EnablingPasswordEntry> map = this.pwRef.get();
        if (map == null) {
            return null;
        }
        EnablingPasswordEntry entry = map.get(alias);
        if (entry == null) {
            return null;
        }
        if (password != null) {
            throw ElytronMessages.log.invalidKeyStoreEntryPassword(alias);
        }
        return entry.getPassword();
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        return null;
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        return null;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        return null;
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        if (password != null) {
            throw new KeyStoreException(ElytronMessages.log.invalidKeyStoreEntryPassword(alias));
        }
        if (key instanceof Password) {
            this.engineSetEntry(alias, new EnablingPasswordEntry((Password)key), null);
        }
        throw ElytronMessages.log.invalidKeyStoreEntryType(alias, Password.class, key.getClass());
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw ElytronMessages.log.invalidKeyStoreEntryType(alias, Password.class, Key.class);
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        throw ElytronMessages.log.invalidKeyStoreEntryType(alias, Password.class, Certificate.class);
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        LinkedHashMap<String, EnablingPasswordEntry> newMap;
        HashMap<String, EnablingPasswordEntry> map;
        do {
            if ((map = this.pwRef.get()) == null || !map.containsKey(alias)) {
                return;
            }
            if (map.size() == 1) {
                newMap = null;
                continue;
            }
            newMap = new LinkedHashMap<String, EnablingPasswordEntry>(map);
            newMap.remove(alias);
        } while (!this.pwRef.compareAndSet(map, newMap));
        if (newMap == null) {
            this.realmName.set(null);
        }
    }

    @Override
    public Enumeration<String> engineAliases() {
        HashMap<String, EnablingPasswordEntry> map = this.pwRef.get();
        return Collections.enumeration(map == null ? Collections.emptySet() : map.keySet());
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        HashMap<String, EnablingPasswordEntry> map = this.pwRef.get();
        return map != null && map.containsKey(alias);
    }

    @Override
    public int engineSize() {
        HashMap<String, EnablingPasswordEntry> map = this.pwRef.get();
        return map == null ? 0 : map.size();
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        return false;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        return false;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        return null;
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        HashMap<String, EnablingPasswordEntry> map = this.pwRef.get();
        String realmName = this.realmName.get();
        ArrayList<String> fileLines = new ArrayList<String>(this.fileContents);
        HashMap<String, EnablingPasswordEntry> toWrite = map != null ? new HashMap<String, EnablingPasswordEntry>(map) : new HashMap();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream));
        for (String line : fileLines) {
            String trimmed = line.trim();
            if (trimmed.length() == 0) {
                writer.newLine();
                continue;
            }
            Matcher matcher = PROPERTY_PATTERN.matcher(trimmed);
            if (matcher.matches()) {
                String username = matcher.group(1);
                if (!toWrite.containsKey(username)) continue;
                String escapedUsername = this.escapeString(username, ESCAPE_ARRAY);
                EnablingPasswordEntry pwdEntry = toWrite.get(username);
                DigestPassword digestPwd = (DigestPassword)pwdEntry.getPassword();
                String property = escapedUsername + "=" + ByteIterator.ofBytes(digestPwd.getDigest()).hexEncode().drainToString();
                if (!pwdEntry.isEnabled()) {
                    writer.write(COMMENT_PREFIX);
                }
                toWrite.remove(username);
                writer.write(property);
                writer.newLine();
                continue;
            }
            writer.write(line);
            writer.newLine();
        }
        for (String username : toWrite.keySet()) {
            EnablingPasswordEntry pwdEntry = toWrite.get(username);
            DigestPassword digestPwd = (DigestPassword)pwdEntry.getPassword();
            String property = this.escapeString(username, ESCAPE_ARRAY) + "=" + ByteIterator.ofBytes(digestPwd.getDigest()).hexEncode().drainToString();
            if (!pwdEntry.isEnabled()) {
                writer.write(COMMENT_PREFIX);
            }
            writer.write(property);
            writer.newLine();
        }
        if (realmName != null) {
            this.writeRealm(writer, realmName);
        }
        writer.close();
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        String currentLine;
        LinkedHashMap<String, EnablingPasswordEntry> map = new LinkedHashMap<String, EnablingPasswordEntry>();
        String realmName = null;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
        ArrayList<String> fileContents = new ArrayList<String>();
        ArrayList<UserEntry> userEntries = new ArrayList<UserEntry>();
        while ((currentLine = reader.readLine()) != null) {
            fileContents.add(currentLine);
            String trimmed = currentLine.trim();
            if (trimmed.startsWith(COMMENT_PREFIX) && trimmed.contains(REALM_COMMENT_PREFIX)) {
                int start = trimmed.indexOf(REALM_COMMENT_PREFIX) + REALM_COMMENT_PREFIX.length();
                int end = trimmed.indexOf(REALM_COMMENT_SUFFIX, start);
                if (end > -1) {
                    realmName = trimmed.substring(start, end);
                }
                fileContents.remove(currentLine);
                fileContents.remove(fileContents.size() - 1);
                reader.readLine();
                continue;
            }
            Matcher matcher = PROPERTY_PATTERN.matcher(trimmed);
            if (!matcher.matches()) continue;
            String userName = matcher.group(1);
            String hexDigest = matcher.group(2);
            boolean commented = trimmed.startsWith(COMMENT_PREFIX);
            userEntries.add(new UserEntry(userName, hexDigest, commented));
        }
        if (userEntries.size() > 0 && realmName == null) {
            throw ElytronMessages.log.noRealmFoundInProperties();
        }
        for (UserEntry entry : userEntries) {
            Password pwd;
            try {
                pwd = this.passwordFactory.generatePassword(new DigestPasswordSpec("digest-md5", entry.username, realmName, CodePointIterator.ofString(entry.hexDigest).hexDecode().drain()));
            }
            catch (InvalidKeySpecException ikse) {
                throw ElytronMessages.log.noAlgorithmForPassword(entry.username);
            }
            map.put(entry.username, new EnablingPasswordEntry(pwd, !entry.isDisabled));
        }
        this.pwRef.set(map.size() > 0 ? map : null);
        this.realmName.set(realmName);
        this.fileContents = fileContents;
    }

    @Override
    public KeyStore.Entry engineGetEntry(String alias, KeyStore.ProtectionParameter protParam) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        HashMap<String, EnablingPasswordEntry> map = this.pwRef.get();
        if (map == null) {
            return null;
        }
        EnablingPasswordEntry key = map.get(alias);
        if (key == null) {
            return null;
        }
        if (protParam != null) {
            throw ElytronMessages.log.invalidKeyStoreEntryPassword(alias);
        }
        return key;
    }

    @Override
    public void engineSetEntry(String alias, KeyStore.Entry entry, KeyStore.ProtectionParameter protParam) throws KeyStoreException {
        LinkedHashMap<Object, Object> newMap;
        HashMap<String, EnablingPasswordEntry> map;
        if (!(entry instanceof EnablingPasswordEntry)) {
            throw ElytronMessages.log.invalidKeyStoreEntryType(alias, EnablingPasswordEntry.class, entry != null ? entry.getClass() : null);
        }
        if (protParam != null) {
            throw ElytronMessages.log.keyCannotBeProtected(alias);
        }
        Password password = ((EnablingPasswordEntry)entry).getPassword();
        if (!(password instanceof DigestPassword)) {
            throw ElytronMessages.log.invalidPasswordType(alias, DigestPassword.class, password != null ? password.getClass() : null);
        }
        String algorithm = password.getAlgorithm();
        if (!"digest-md5".equals(algorithm)) {
            throw ElytronMessages.log.invalidAlgorithmInPasswordEntry(alias, "digest-md5", algorithm);
        }
        String keyStoreRealm = this.realmName.get();
        String passwordRealm = ((DigestPassword)password).getRealm();
        if (passwordRealm == null) {
            throw ElytronMessages.log.invalidNullRealmInPasswordEntry();
        }
        if (keyStoreRealm != null && !keyStoreRealm.equals(passwordRealm)) {
            throw ElytronMessages.log.invalidRealmNameInPasswordEntry(alias, keyStoreRealm, passwordRealm);
        }
        if (keyStoreRealm == null && !this.realmName.compareAndSet(keyStoreRealm, passwordRealm) && !this.realmName.get().equals(passwordRealm)) {
            throw ElytronMessages.log.invalidRealmNameInPasswordEntry(alias, this.realmName.get(), passwordRealm);
        }
        do {
            newMap = (map = this.pwRef.get()) == null ? new LinkedHashMap(1) : new LinkedHashMap<String, EnablingPasswordEntry>(map);
            newMap.put(alias, (EnablingPasswordEntry)entry);
        } while (!this.pwRef.compareAndSet(map, newMap));
    }

    @Override
    public boolean engineEntryInstanceOf(String alias, Class<? extends KeyStore.Entry> entryClass) {
        HashMap<String, EnablingPasswordEntry> map = this.pwRef.get();
        return map != null && entryClass.isInstance(map.get(alias));
    }

    private String escapeString(String name, char[] escapeArray) {
        Arrays.sort(escapeArray);
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (Arrays.binarySearch(escapeArray, ch) < 0) continue;
            StringBuilder builder = new StringBuilder();
            builder.append(name, 0, i);
            builder.append('\\').append(ch);
            for (int j = i + 1; j < name.length(); ++j) {
                ch = name.charAt(j);
                if (Arrays.binarySearch(escapeArray, ch) >= 0) {
                    builder.append('\\');
                }
                builder.append(ch);
            }
            return builder.toString();
        }
        return name;
    }

    private void writeRealm(BufferedWriter bw, String realmName) throws IOException {
        bw.append(COMMENT_PREFIX);
        bw.newLine();
        bw.append(COMMENT_PREFIX);
        bw.append(REALM_COMMENT_PREFIX);
        bw.append(realmName);
        bw.append(REALM_COMMENT_SUFFIX);
        bw.append(REALM_COMMENT_COMMENT);
        bw.newLine();
        bw.append(COMMENT_PREFIX);
        bw.newLine();
    }

    private class UserEntry {
        String username;
        String hexDigest;
        boolean isDisabled;

        UserEntry(String username, String hexDigest, boolean isDisabled) {
            this.username = username;
            this.hexDigest = hexDigest;
            this.isDisabled = isDisabled;
        }
    }
}

