/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslClientFactory;
import org.wildfly.security.sasl.util.PrivilegedSaslClient;

public final class PrivilegedSaslClientFactory
extends AbstractDelegatingSaslClientFactory {
    private final AccessControlContext context;

    public PrivilegedSaslClientFactory(SaslClientFactory delegate) {
        this(delegate, AccessController.getContext());
    }

    PrivilegedSaslClientFactory(SaslClientFactory delegate, AccessControlContext context) {
        super(delegate);
        this.context = context;
    }

    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        SaslClient saslClient = this.delegate.createSaslClient(mechanisms, authorizationId, protocol, serverName, props, cbh);
        return saslClient == null ? null : new PrivilegedSaslClient(saslClient, this.context);
    }
}

