/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Collection;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.wildfly.common.Assert;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.RuleNode;
import org.wildfly.security.auth.client.SetHostAuthenticationConfiguration;
import org.wildfly.security.auth.client.SetPortAuthenticationConfiguration;
import org.wildfly.security.auth.principal.AnonymousPrincipal;
import org.wildfly.security.permission.ElytronPermission;

public final class AuthenticationContextConfigurationClient {
    private static final ElytronPermission CREATE_PERMISSION = new ElytronPermission("createAuthenticationContextConfigurationClient");
    public static final PrivilegedAction<AuthenticationContextConfigurationClient> ACTION = AuthenticationContextConfigurationClient::new;

    public AuthenticationContextConfigurationClient() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CREATE_PERMISSION);
        }
    }

    public AuthenticationConfiguration getAuthenticationConfiguration(URI uri, AuthenticationContext authenticationContext) {
        return this.getAuthenticationConfiguration(uri, authenticationContext, -1);
    }

    public AuthenticationConfiguration getAuthenticationConfiguration(URI uri, AuthenticationContext authenticationContext, int protocolDefaultPort) {
        return this.getAuthenticationConfiguration(uri, authenticationContext, protocolDefaultPort, null, null);
    }

    public AuthenticationConfiguration getAuthenticationConfiguration(URI uri, AuthenticationContext authenticationContext, int protocolDefaultPort, String abstractType, String abstractTypeAuthority) {
        return this.getAuthenticationConfiguration(uri, authenticationContext, protocolDefaultPort, abstractType, abstractTypeAuthority, null);
    }

    public AuthenticationConfiguration getAuthenticationConfiguration(URI uri, AuthenticationContext authenticationContext, int protocolDefaultPort, String abstractType, String abstractTypeAuthority, String purpose) {
        String userInfo;
        int port;
        Assert.checkNotNullParam((String)"uri", (Object)uri);
        Assert.checkNotNullParam((String)"authenticationContext", (Object)authenticationContext);
        RuleNode<AuthenticationConfiguration> node = authenticationContext.authRuleMatching(uri, abstractType, abstractTypeAuthority, purpose);
        if (node == null) {
            return AuthenticationConfiguration.EMPTY;
        }
        AuthenticationConfiguration configuration = node.getConfiguration();
        String uriHost = uri.getHost();
        if (uriHost != null && !configuration.delegatesThrough(SetHostAuthenticationConfiguration.class)) {
            configuration = configuration.useHost(uriHost);
        }
        if ((port = uri.getPort()) == -1) {
            port = protocolDefaultPort;
        }
        if (port != -1 && !configuration.delegatesThrough(SetPortAuthenticationConfiguration.class)) {
            configuration = configuration.usePort(port);
        }
        if ((userInfo = uri.getUserInfo()) != null && configuration.getPrincipal() == AnonymousPrincipal.getInstance()) {
            configuration = configuration.useName(userInfo);
        }
        return configuration;
    }

    public SSLContext getSSLContext(URI uri, AuthenticationContext authenticationContext) throws GeneralSecurityException {
        return this.getSSLContext(uri, authenticationContext, null, null);
    }

    public SSLContext getSSLContext(URI uri, AuthenticationContext authenticationContext, String abstractType, String abstractTypeAuthority) throws GeneralSecurityException {
        return this.getSSLContext(uri, authenticationContext, abstractType, abstractTypeAuthority, null);
    }

    public SSLContext getSSLContext(URI uri, AuthenticationContext authenticationContext, String abstractType, String abstractTypeAuthority, String purpose) throws GeneralSecurityException {
        return this.getSSLContextFactory(uri, authenticationContext, abstractType, abstractTypeAuthority, purpose).create();
    }

    public SecurityFactory<SSLContext> getSSLContextFactory(URI uri, AuthenticationContext authenticationContext, String abstractType, String abstractTypeAuthority, String purpose) {
        Assert.checkNotNullParam((String)"uri", (Object)uri);
        Assert.checkNotNullParam((String)"authenticationContext", (Object)authenticationContext);
        RuleNode<SecurityFactory<SSLContext>> node = authenticationContext.sslRuleMatching(uri, abstractType, abstractTypeAuthority, purpose);
        if (node == null) {
            return SSLContext::getDefault;
        }
        return node.getConfiguration();
    }

    public CallbackHandler getCallbackHandler(AuthenticationConfiguration configuration) {
        Assert.checkNotNullParam((String)"configuration", (Object)configuration);
        return configuration.getCallbackHandler();
    }

    public String getRealHost(URI uri, AuthenticationConfiguration configuration) {
        Assert.checkNotNullParam((String)"uri", (Object)uri);
        Assert.checkNotNullParam((String)"configuration", (Object)configuration);
        String configurationHost = configuration.getHost();
        return configurationHost == null ? uri.getHost() : configurationHost;
    }

    public String getRealHost(AuthenticationConfiguration configuration) {
        Assert.checkNotNullParam((String)"configuration", (Object)configuration);
        return configuration.getHost();
    }

    public int getRealPort(URI uri, AuthenticationConfiguration configuration) {
        Assert.checkNotNullParam((String)"uri", (Object)uri);
        Assert.checkNotNullParam((String)"configuration", (Object)configuration);
        int configurationPort = configuration.getPort();
        return configurationPort == -1 ? uri.getPort() : configurationPort;
    }

    public int getRealPort(AuthenticationConfiguration configuration) {
        Assert.checkNotNullParam((String)"configuration", (Object)configuration);
        return configuration.getPort();
    }

    public Principal getPrincipal(AuthenticationConfiguration configuration) {
        Assert.checkNotNullParam((String)"configuration", (Object)configuration);
        return configuration.getPrincipal();
    }

    public SaslClient createSaslClient(URI uri, AuthenticationConfiguration configuration, SaslClientFactory clientFactory, Collection<String> offeredMechanisms) throws SaslException {
        return configuration.createSaslClient(uri, clientFactory, offeredMechanisms);
    }

    public InetSocketAddress getDestinationInetSocketAddress(URI uri, AuthenticationConfiguration configuration, int protocolDefaultPort) {
        int port;
        Assert.checkNotNullParam((String)"uri", (Object)uri);
        Assert.checkNotNullParam((String)"configuration", (Object)configuration);
        String host = configuration.getHost();
        if (host == null) {
            host = uri.getHost();
        }
        if ((port = configuration.getPort()) == -1) {
            port = uri.getPort();
        }
        if (port == -1) {
            port = protocolDefaultPort;
        }
        return new InetSocketAddress(host, port);
    }

    public InetSocketAddress getDestinationInetSocketAddress(AuthenticationConfiguration configuration) {
        Assert.checkNotNullParam((String)"configuration", (Object)configuration);
        return new InetSocketAddress(configuration.getHost(), configuration.getPort());
    }

    public Socket connect(URI uri, AuthenticationConfiguration configuration, int protocolDefaultPort) throws IOException {
        InetSocketAddress address = this.getDestinationInetSocketAddress(uri, configuration, protocolDefaultPort);
        return new Socket(address.getAddress(), address.getPort());
    }
}

